/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.pattern;

import java.io.PrintWriter;
import java.util.List;
import obp.cdl.PropertyDeclaration;
import obp.dot.Graph;
import obp.dot.util.DotUtil;
import obp.obs.Observer;
import obp.transfo.property.PropertyToObserver;
import obp.ui.Resources;
import obp.ui.dot.diagram.GraphDiagram;
import obp.ui.pattern.CdlTextField;
import obp.ui.util.FileTools;
import obp.util.CDLUtil;
import obp.util.ObsUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.PlatformUtil;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.dialog.FieldShellToolkit;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.ConsoleField;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.MultiTabField;
import org.xid.basics.ui.field.TextField;

public class Pattern2ObsUI {
    String version = "vers. 7 juin 11";
    int displayHight = 1000;
    int displayWidth = 750;
    String Dot_Path_PC_Phil = "C:/cygwin/bin/dot.exe";
    String Dot_Path_Linux = "/usr/local/bin/dot";
    private Display display;
    private Shell shell;
    private FieldShellToolkit toolkit;
    private Resources resources;
    private TextField dotField;
    private CdlTextField cdlField;
    private ChoiceField<PropertyDeclaration> propertyChoiceField;
    private DiagramField<Graph> graphField;
    private ConsoleField consoleField;
    private Runnable transformRunnable = new Runnable(){

        @Override
        public void run() {
            Pattern2ObsUI.this.transformPattern();
        }
    };

    public void open() throws Exception {
        this.display = new Display();
        this.resources = (Resources)Resources.getInstance(Resources.class);
        this.shell = FieldShellToolkit.createShell((Display)this.display, (String)("OBP: Pattern to Observer " + this.version));
        this.toolkit = new FieldShellToolkit(this.shell, "OBP: Pattern to Observer " + this.version, 0, this.createFields());
        this.toolkit.setBannerImage(this.resources.getImage("obp100x66.png"));
        this.toolkit.init();
        PlatformUtil.registerCocoaNameAboutAndPreference((String)"OBP", (Action)new Action.Stub(), null);
        this.refreshFields();
        this.toolkit.validateAll();
        this.shell.setSize(this.displayHight, this.displayWidth);
        this.shell.open();
        String nomFichier = FileTools.fileChoice(this.display, this.shell, "cdl");
        if (nomFichier != null) {
            System.out.println("fichier choisi : " + nomFichier);
            this.cdlField.setValue(FileTools.fileLoad(nomFichier));
        }
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.dispose();
    }

    private Field createFields() throws Exception {
        this.cdlField = new CdlTextField();
        this.cdlField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.name.equals("value")) {
                    if (Pattern2ObsUI.this.cdlField.getUnit() != null) {
                        List<PropertyDeclaration> propertyRange = CDLUtil.findAllDeclarations(Pattern2ObsUI.this.cdlField.getUnit(), PropertyDeclaration.class);
                        Pattern2ObsUI.this.propertyChoiceField.setRange(propertyRange);
                        if (propertyRange.size() > 0) {
                            Pattern2ObsUI.this.propertyChoiceField.setValue((Object)propertyRange.get(0));
                        }
                    } else {
                        Pattern2ObsUI.this.propertyChoiceField.setRange(null);
                        Pattern2ObsUI.this.propertyChoiceField.setValue(null);
                    }
                }
            }
        });
        this.propertyChoiceField = new ChoiceField<PropertyDeclaration>("Property", 34){

            public String getText(PropertyDeclaration element) {
                return element.getName();
            }
        };
        this.propertyChoiceField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.name.equals("value")) {
                    Pattern2ObsUI.this.display.timerExec(100, Pattern2ObsUI.this.transformRunnable);
                }
            }
        });
        CompositeField cdlCompositeField = new CompositeField(new Field[]{this.cdlField, this.propertyChoiceField});
        this.graphField = new DiagramField((Diagram)new GraphDiagram());
        CompositeField graphCompositeField = new CompositeField("Observer", new Field[]{this.graphField});
        this.dotField = new TextField(null, 3);
        this.dotField.setNbLines(10);
        CompositeField dotCompositeField = new CompositeField("Dot", new Field[]{this.dotField});
        MultiTabField observerTabField = new MultiTabField();
        observerTabField.addTab((Field)graphCompositeField, null, false);
        observerTabField.addTab((Field)dotCompositeField, null, false);
        this.consoleField = new ConsoleField();
        BorderField mainField = new BorderField(0, (Field)observerTabField);
        mainField.setWest((Field)cdlCompositeField, 40);
        mainField.setSouth((Field)this.consoleField, 20);
        this.consoleField.addAction((Action)new Action.Stub("Load PTY"){

            public int run(ActionMonitor monitor) {
                String content = new String();
                System.out.println("\nLoad PTY");
                String nomFichier = FileTools.fileChoice(Pattern2ObsUI.this.display, Pattern2ObsUI.this.shell, "cdl");
                System.out.println("fichier choisi : " + nomFichier);
                try {
                    content = FileTools.fileLoad(nomFichier);
                    Pattern2ObsUI.this.cdlField.setValue(content);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                return 1;
            }
        });
        this.consoleField.addAction((Action)new Action.Stub("Exit"){

            public int run(ActionMonitor monitor) {
                System.exit(0);
                return 1;
            }
        });
        return mainField;
    }

    public void refreshFields() {
    }

    public void dispose() {
        Resources.releaseInstance(Resources.class);
    }

    public void log(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Pattern2ObsUI.this.consoleField.log(message);
            }
        });
    }

    public void warning(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Pattern2ObsUI.this.consoleField.log(message, 8, 2);
            }
        });
    }

    public void error(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Pattern2ObsUI.this.consoleField.log(message, 4, 1);
            }
        });
    }

    public void clearConsole() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Pattern2ObsUI.this.consoleField.clear();
            }
        });
    }

    public void transformPattern() {
        this.graphField.setValue(null);
        PropertyDeclaration property = (PropertyDeclaration)this.propertyChoiceField.getValue();
        if (property == null) {
            return;
        }
        PrintWriter writer = this.consoleField.createPrintWriter(2, 0);
        PropertyToObserver transformer = new PropertyToObserver(writer);
        Observer observer = transformer.toObserver(property);
        writer.flush();
        try {
            String dot = ObsUtil.toDot(observer);
            Graph graph = DotUtil.layoutDot(dot);
            this.graphField.setValue((Object)graph);
            this.dotField.setValue(dot);
        }
        catch (Exception e) {
            this.error(DiagnosticUtil.createMessage((Throwable)e) + "/n");
        }
    }

    public static void main(String[] args) throws Exception {
        Pattern2ObsUI p = new Pattern2ObsUI();
        DotUtil.dotExecutable = p.Dot_Path_Linux;
        p.open();
    }
}

