/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.obs;

import java.util.List;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.obs.DelayAction;

public class Action {
    public final List<AtomicAction> atomicActions;
    public final int targetId;
    private static String INTERNAL_ACTION_GRAPH = "";
    private static String INTERNAL_ACTION = "internal";
    private static String STRING_SEPARATOR = ";";

    public Action(List<AtomicAction> atomicActions, int targetId) {
        this.atomicActions = atomicActions;
        this.targetId = targetId;
    }

    public String toFancyStringForGraph(SymbolsTable symbols) {
        StringBuilder label = new StringBuilder();
        int numberOfDisplayedActions = 0;
        for (AtomicAction action : this.atomicActions) {
            if (action instanceof DelayAction) continue;
            label.append(action.toFancyString(symbols));
            if (numberOfDisplayedActions > 0) {
                label.append(STRING_SEPARATOR);
            }
            ++numberOfDisplayedActions;
        }
        if (numberOfDisplayedActions == 0) {
            return INTERNAL_ACTION_GRAPH;
        }
        return label.toString();
    }

    public String toFancyString(SymbolsTable symbols) {
        StringBuilder label = new StringBuilder();
        int numberOfDisplayedActions = 0;
        for (AtomicAction action : this.atomicActions) {
            label.append(action.toFancyString(symbols));
            if (numberOfDisplayedActions <= 0) continue;
            label.append(STRING_SEPARATOR);
        }
        if (numberOfDisplayedActions == 0) {
            return INTERNAL_ACTION;
        }
        return label.toString();
    }
}

