/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDPrefix;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.runtime.AEFDRuntimeInfos;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import java.util.LinkedList;

public class AEFDRuntimeActionExecutor
extends AEFDModelVisitor.Stub {
    private final AEFDRuntimeInfos infos;
    private AEFDRuntimeSystemState currentTarget;

    public AEFDRuntimeActionExecutor(AEFDRuntimeInfos infos) {
        this.infos = infos;
    }

    public void executeActions(AEFDRuntimeSystemState target, AEFDTransition transition) {
        this.currentTarget = target;
        transition.accept((AEFDModelVisitor)this);
    }

    public void visitTransition(AEFDTransition transition) {
        transition.getAction().accept((AEFDModelVisitor)this);
    }

    public void visitActionSequence(AEFDActionSequence actionSequence) {
        for (AEFDAction action : actionSequence.getActionList()) {
            action.accept((AEFDModelVisitor)this);
        }
    }

    public void visitSendEvent(AEFDAction.SendEvent sendEvent) {
        LinkedList<Integer> targetQueue = sendEvent.getFunctionalEntity().getPrefix().equals((Object)AEFDPrefix.ACT) ? this.currentTarget.getHighPriorityQueue() : this.currentTarget.getLowPriorityQueue();
        int eventIndex = this.infos.getEventIndex(sendEvent.getFunctionalEntity());
        targetQueue.addLast(eventIndex);
    }

    public void visitAffectation(AEFDAction.Affectation affectation) {
        int variableIndex = this.infos.getVariableIndex(affectation.getVariable());
        this.currentTarget.getVariables()[variableIndex] = affectation.getNewValue();
    }

    public void visitProperty(AEFDAction.Property property) {
        AEFDFunctionalEntity functionalEntity = property.getFunctionalEntity();
        if (!functionalEntity.getPrefix().equals((Object)AEFDPrefix.P)) {
            throw new IllegalStateException("Incorrect prefix (" + functionalEntity.getIdentifier() + ") for a property");
        }
        switch (functionalEntity.getIdentifier()) {
            case "P_5": {
                this.currentTarget.setReject(true);
                break;
            }
            case "P_6": {
                this.currentTarget.setCut(true);
                break;
            }
            case "P_7": {
                this.currentTarget.setWarning(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown property identifier (" + functionalEntity.getIdentifier() + ")");
            }
        }
    }
}

