/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.printer.fiacre;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.HelperBus;
import obp.fiacre.model.Arg;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.Composition;
import obp.fiacre.model.Instance;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.Par;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.Type;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;

public class ComponentGenerator
extends HelperBus.Abstract {
    private AEFDModel model;
    private LocalVariable currentEvent;
    private LocalVariable hFifo;
    private LocalVariable lFifo;
    private LocalVariable variablesArray;
    private LocalVariable enabledArray;
    private AEFDAutomate environment;

    public ComponentGenerator(HelperBus helper) {
        super(helper);
    }

    private void fetchEnvironment() {
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            if (!automate.getName().equals("Environment")) continue;
            this.environment = automate;
        }
    }

    private void buildCurrentEvent() {
        this.currentEvent = new LocalVariable();
        this.currentEvent.setName("currentEvent");
        this.currentEvent.setType((Type)this.helper.events.getUnionTypeId());
        this.currentEvent.setInitializer(this.helper.builder.initialValue(this.currentEvent.getType()));
    }

    private void buildHFifo() {
        this.hFifo = new LocalVariable();
        this.hFifo.setName("hFIFO");
        this.hFifo.setType((Type)this.helper.events.getFifoTypeId());
        this.hFifo.setInitializer(this.helper.builder.initialValue(this.hFifo.getType()));
    }

    private void buildLFifo() {
        this.lFifo = new LocalVariable();
        this.lFifo.setName("lFIFO");
        this.lFifo.setType((Type)this.helper.events.getFifoTypeId());
        this.lFifo.setInitializer(this.helper.builder.initialValue(this.lFifo.getType()));
    }

    private void buildEnabledArray() {
        this.enabledArray = this.helper.processEnabledArray.buildLocalVariable();
    }

    private InterfacedComp getSchedulerInstance() {
        InterfacedComp instance = new InterfacedComp();
        Instance processInstance = new Instance();
        processInstance.setType((NodeDecl)this.helper.scheduler.getProcessDecl());
        RefArg currentEventArg = new RefArg();
        currentEventArg.setRef((Variable)this.currentEvent);
        processInstance.addArg((Arg)currentEventArg);
        RefArg highPriorityArg = new RefArg();
        highPriorityArg.setRef((Variable)this.hFifo);
        processInstance.addArg((Arg)highPriorityArg);
        RefArg lowPriorityArg = new RefArg();
        lowPriorityArg.setRef((Variable)this.lFifo);
        processInstance.addArg((Arg)lowPriorityArg);
        RefArg enabledArrayArg = new RefArg();
        enabledArrayArg.setRef((Variable)this.enabledArray);
        processInstance.addArg((Arg)enabledArrayArg);
        instance.setComposition((Composition)processInstance);
        return instance;
    }

    public ComponentDecl generate(AEFDModel model) {
        this.model = model;
        this.fetchEnvironment();
        ComponentDecl comp = new ComponentDecl();
        comp.setName("SUS");
        this.buildCurrentEvent();
        comp.addVar(this.currentEvent);
        this.buildHFifo();
        comp.addVar(this.hFifo);
        this.buildLFifo();
        comp.addVar(this.lFifo);
        this.variablesArray = this.helper.booleanVariablesArray.buildLocalVariable();
        comp.addVar(this.variablesArray);
        this.buildEnabledArray();
        comp.addVar(this.enabledArray);
        VarRef arrayRef = new VarRef();
        arrayRef.setDecl((Variable)this.enabledArray);
        comp.setInitAction(this.helper.processEnabledArray.buildAffectation(arrayRef, this.environment, true));
        Par par = new Par();
        comp.setBody((Composition)par);
        for (AEFDAutomate automate : model.getAllAutomates()) {
            InterfacedComp inst = new InterfacedComp();
            Instance processInstance = new Instance();
            processInstance.setType((NodeDecl)this.helper.processes.getProcessDecl(automate));
            RefArg currentEventArg = new RefArg();
            currentEventArg.setRef((Variable)this.currentEvent);
            processInstance.addArg((Arg)currentEventArg);
            RefArg highPriorityArg = new RefArg();
            highPriorityArg.setRef((Variable)this.hFifo);
            processInstance.addArg((Arg)highPriorityArg);
            RefArg lowPriorityArg = new RefArg();
            lowPriorityArg.setRef((Variable)this.lFifo);
            processInstance.addArg((Arg)lowPriorityArg);
            RefArg variablesArg = new RefArg();
            variablesArg.setRef((Variable)this.variablesArray);
            processInstance.addArg((Arg)variablesArg);
            RefArg enabledArg = new RefArg();
            enabledArg.setRef((Variable)this.enabledArray);
            processInstance.addArg((Arg)enabledArg);
            inst.setComposition((Composition)processInstance);
            par.addArg(inst);
        }
        par.addArg(this.getSchedulerInstance());
        return comp;
    }
}

