/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.fiacre;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import obp.dot.Graph;
import obp.dot.util.DotUtil;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Program;
import obp.fiacre.util.FiacreDotPrinter;
import obp.fiacre.util.FiacreUtil;
import obp.ui.dot.diagram.GraphDiagram;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.diagram.DiagramController;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.MultiPageField;
import org.xid.basics.ui.field.TextField;

public class ProgramController
extends Controller<String> {
    private final ErrorHandler errorHandler;
    private final FiacreDotPrinter dotPrinter = new FiacreDotPrinter(true);
    private MultiPageField programField;
    private ListField<NodeDecl> programDeclarationListField;
    private DiagramField<Graph> programDeclarationGraphField;
    private TextField programSourceField;
    private Program program;
    private Map<Declaration, Graph> declarationGraphCache;

    public ProgramController(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public CompositeField createFields() {
        this.programSourceField = new TextField(null, 3);
        this.programSourceField.setNbLines(3);
        this.programDeclarationListField = new ListField<NodeDecl>(null, 2){

            public String getText(NodeDecl element) {
                StringBuilder text = new StringBuilder();
                text.append("[");
                text.append(element.getClass().getSimpleName().substring(0, 4));
                text.append("] ");
                text.append(element.getName());
                return text.toString();
            }
        };
        this.programDeclarationGraphField = new DiagramField((Diagram)new GraphDiagram());
        DiagramController diagramController = this.programDeclarationGraphField.getController();
        this.programDeclarationGraphField.addAction(diagramController.createIncreaseZoomAction());
        this.programDeclarationGraphField.addAction(diagramController.createDecreaseZoomAction());
        this.programDeclarationGraphField.addAction(diagramController.createSaveImageAction());
        BorderField programGraphField = new BorderField(2, this.programDeclarationGraphField);
        programGraphField.setWest(this.programDeclarationListField, 20);
        this.programField = new MultiPageField(new Field[]{programGraphField, this.programSourceField});
        this.programField.setSelected(0);
        CompositeField programCompositeField = new CompositeField("Program", new Field[]{this.programField});
        return programCompositeField;
    }

    public void setSubject(String subject) {
        if (subject != this.subject) {
            super.setSubject((Object)subject);
            this.program = null;
            if (subject != null) {
                try {
                    this.program = FiacreUtil.loadProgram(subject);
                    this.declarationGraphCache = new HashMap<Declaration, Graph>();
                }
                catch (Exception e) {
                    this.errorHandler.handleError(2, DiagnosticUtil.createMessage((Throwable)e) + "\n");
                    this.program = null;
                    this.declarationGraphCache = null;
                }
            }
        }
    }

    public void refreshFields() {
        this.programSourceField.setValue((String)this.getSubject());
        NodeDecl nodeSelection = (NodeDecl)this.programDeclarationListField.getSingleSelection();
        String selectedProcessName = nodeSelection != null ? nodeSelection.getName() : null;
        this.programDeclarationListField.setValue(this.getNodeDeclList());
        if (this.program != null) {
            NodeDecl newNodeSelection = FiacreUtil.findDeclaration(selectedProcessName, NodeDecl.class, this.program);
            this.programDeclarationListField.setSingleSelection((Object)newNodeSelection);
        }
        this.refreshDeclarationGraph();
    }

    public boolean updateSubject(Field field) {
        if (field == this.programDeclarationListField) {
            this.refreshDeclarationGraph();
            return false;
        }
        return false;
    }

    public void showProgramSource(boolean show) {
        if (show) {
            this.programField.setSelected(1);
        } else {
            this.programField.setSelected(0);
        }
    }

    public boolean isUseDescription() {
        return this.dotPrinter.isUseDescription();
    }

    public void setUseDescription(boolean useDescription) {
        this.dotPrinter.setUseDescription(useDescription);
        this.clearDeclarationGraphCache();
    }

    public boolean isShowPogramSource() {
        return this.programField.getSelected() == 1;
    }

    public Program getProgram() {
        return this.program;
    }

    private List<NodeDecl> getNodeDeclList() {
        if (this.program == null) {
            return null;
        }
        ArrayList<NodeDecl> result = new ArrayList<NodeDecl>();
        for (Declaration declaration : this.program.getDeclarationList()) {
            if (!(declaration instanceof NodeDecl)) continue;
            result.add((NodeDecl)declaration);
        }
        return result;
    }

    private void refreshDeclarationGraph() {
        Declaration declaration = (Declaration)this.programDeclarationListField.getSingleSelection();
        Graph graph = null;
        if (declaration != null) {
            if (!this.declarationGraphCache.containsKey(declaration)) {
                if (declaration instanceof ProcessDecl) {
                    try {
                        String dot = this.dotPrinter.toDot((ProcessDecl)declaration);
                        graph = DotUtil.layoutDot(dot);
                        this.declarationGraphCache.put(declaration, graph);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                graph = this.declarationGraphCache.get(declaration);
            }
        }
        this.programDeclarationGraphField.setValue(graph);
    }

    private void clearDeclarationGraphCache() {
        this.declarationGraphCache = new HashMap<Declaration, Graph>();
    }
}

