/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.graph;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class DotWriter {
    File out;
    String header = "digraph \"test\" {\ngraph [fontsize=30 rankdir=\"LR\"];\nnode [shape=circle, color=lightblue2, style=filled, fontsize=30];\nedge [fontsize = 30];\n}";
    static final String style = ", fontsize = 15];";

    public DotWriter(File out, boolean forState) {
        this.out = out;
        this.init();
        System.out.println("GraphFile : " + out.getPath());
    }

    public void init() {
        try {
            FileOutputStream fos = new FileOutputStream(this.out);
            fos.write(this.header.getBytes());
            fos.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void newLine(String noeud) {
        try {
            this.deleteLastLine(this.out);
            FileWriter fichier = new FileWriter(this.out, true);
            fichier.write("node [shape = doublecircle];\"" + noeud + "\";\n");
            fichier.write("node [shape = circle];\n}");
            fichier.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void newLine(String idDebut, String idFin, String transition) {
        Vector<String> monVector = new Vector<String>();
        String newLine = "\"" + idDebut + "\" -> \"" + idFin + "\" [label = \"" + transition + "\"" + style + "\n}";
        try {
            BufferedReader b = new BufferedReader(new FileReader(this.out));
            String ligne = b.readLine();
            while (ligne != null) {
                monVector.addElement(ligne);
                ligne = b.readLine();
            }
            b.close();
            String last = (String)monVector.lastElement();
            monVector.remove(last);
            PrintWriter P = new PrintWriter(new FileWriter(this.out));
            for (int i = 0; i < monVector.size(); ++i) {
                P.println((String)monVector.get(i));
            }
            P.println(newLine);
            P.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.out;
    }

    public void deleteLastLine(File out) throws IOException {
        Vector<String> monVector = new Vector<String>();
        BufferedReader b = new BufferedReader(new FileReader(out));
        String ligne = b.readLine();
        while (ligne != null) {
            monVector.addElement(ligne);
            ligne = b.readLine();
        }
        b.close();
        String last = (String)monVector.lastElement();
        monVector.remove(last);
        PrintWriter P = new PrintWriter(new FileWriter(out));
        for (int i = 0; i < monVector.size(); ++i) {
            P.println((String)monVector.get(i));
        }
        P.close();
    }

    public void exit() {
        this.out.delete();
    }
}

