/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.simulation;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import obp.cc.ConcreteContext;
import obp.explorer.ExplorerResult;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.fiacre.ConcreteContextEnvFactory;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.simulation.ITransitionSelectionPolicy;
import obp.explorer.runtime.simulation.RandomPolicy;

public abstract class Simulator
extends AbstractExplorer {
    protected Queue<Configuration> toSee;
    protected ITransitionSelectionPolicy mSelectionPolicy;
    public int behaviorCount;

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Simulator theClone = (Simulator)super.clone();
        theClone.toSee = this.toSee == null ? null : new ArrayDeque<Configuration>(this.toSee);
        return theClone;
    }

    public Simulator(ProgramLoader programLoader) {
        this(programLoader, null);
    }

    public Simulator(ProgramLoader programLoader, ConcreteContext context) {
        this(programLoader, context, (ITransitionSelectionPolicy)null);
    }

    public Simulator(ProgramLoader programLoader, ConcreteContext context, ITransitionSelectionPolicy policy) {
        super(programLoader, context, context == null ? null : new ConcreteContextEnvFactory(context));
        this.mSelectionPolicy = policy == null ? new RandomPolicy() : policy;
    }

    @Override
    public void initializeExploration() {
        this.toSee = new ArrayDeque<Configuration>();
        this.mSelectionPolicy.initializePolicy();
        super.initializeExploration();
    }

    @Override
    public boolean atEnd() {
        return this.toSee.isEmpty();
    }

    @Override
    public Configuration nextConfiguration() {
        return this.toSee.remove();
    }

    @Override
    protected void onNewConfiguration(Configuration newConfiguration) {
        this.toSee.add(newConfiguration);
    }

    @Override
    protected void onExistingConfiguration(Configuration configuration) {
        this.toSee.add(configuration);
    }

    @Override
    protected void onRegisterActionAndTarget(Configuration source, List<AtomicAction> actions2, Configuration target) {
    }

    @Override
    protected void explorationStep() {
        this.checkMemoryLimit(this.minMemory, this.maxMemory, 1000);
        Configuration configuration = this.nextConfiguration();
        this.simulate(configuration);
        this.saveConfiguration(configuration);
    }

    public ExplorerResult simulate() {
        return this.explore();
    }

    protected abstract void simulate(Configuration var1);
}

