/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.util.Arrays;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.ITransitionExecutor;
import obp.explorer.runtime.core.Transition;

public class SynchronizationExecuter
implements Cloneable {
    AbstractExplorer explorer;
    private Transition[][] inputTransitionsByChannels;
    private int[] inputTransitionByChannelCounts;
    private Transition[][] outputTransitionsByChannels;
    private int[] outputTransitionByChannelCounts;

    protected Object clone() throws CloneNotSupportedException {
        SynchronizationExecuter theClone = (SynchronizationExecuter)super.clone();
        theClone.explorer = null;
        return theClone;
    }

    public SynchronizationExecuter(AbstractExplorer explorer) {
        this.explorer = explorer;
    }

    public void init() {
        int i;
        this.inputTransitionsByChannels = new Transition[this.explorer.getChannelCount()][];
        for (i = 0; i < this.inputTransitionsByChannels.length; ++i) {
            this.inputTransitionsByChannels[i] = new Transition[10];
        }
        this.inputTransitionByChannelCounts = new int[this.explorer.getChannelCount()];
        this.outputTransitionsByChannels = new Transition[this.explorer.getChannelCount()][];
        for (i = 0; i < this.outputTransitionsByChannels.length; ++i) {
            this.outputTransitionsByChannels[i] = new Transition[10];
        }
        this.outputTransitionByChannelCounts = new int[this.explorer.getChannelCount()];
    }

    public void addTransition(int channelId, Transition transition) {
        short type = transition.getSynchronisationType();
        if (type == 1) {
            int transitionForChannelCount = this.inputTransitionByChannelCounts[channelId];
            Transition[] transitionForChannel = this.inputTransitionsByChannels[channelId];
            if (transitionForChannelCount >= transitionForChannel.length) {
                transitionForChannel = Arrays.copyOf(transitionForChannel, transitionForChannel.length * 2);
                this.inputTransitionsByChannels[channelId] = transitionForChannel;
            }
            transitionForChannel[transitionForChannelCount] = transition;
            int n = channelId;
            this.inputTransitionByChannelCounts[n] = this.inputTransitionByChannelCounts[n] + 1;
        } else if (type == 2) {
            int transitionForChannelCount = this.outputTransitionByChannelCounts[channelId];
            Transition[] transitionForChannel = this.outputTransitionsByChannels[channelId];
            if (transitionForChannelCount >= transitionForChannel.length) {
                transitionForChannel = Arrays.copyOf(transitionForChannel, transitionForChannel.length * 2);
                this.outputTransitionsByChannels[channelId] = transitionForChannel;
            }
            transitionForChannel[transitionForChannelCount] = transition;
            int n = channelId;
            this.outputTransitionByChannelCounts[n] = this.outputTransitionByChannelCounts[n] + 1;
        }
    }

    public void computeActivations(boolean[] active) {
        for (short i = 0; i < this.explorer.getChannelCount(); i = (short)(i + 1)) {
            Channel channel = this.explorer.getChannel(i);
            active[i] = channel.isActive(this.outputTransitionsByChannels[i], this.outputTransitionByChannelCounts[i], this.inputTransitionsByChannels[i], this.inputTransitionByChannelCounts[i]);
        }
        Arrays.fill(this.inputTransitionByChannelCounts, 0);
        Arrays.fill(this.outputTransitionByChannelCounts, 0);
    }

    public boolean computeSynchronizedTransition(Configuration configuration, ITransitionExecutor executer) {
        boolean synchronizationExecuted = false;
        for (short i = 0; i < this.explorer.getChannelCount(); i = (short)(i + 1)) {
            Channel channel = this.explorer.getChannel(i);
            boolean active = channel.isActive(this.outputTransitionsByChannels[i], this.outputTransitionByChannelCounts[i], this.inputTransitionsByChannels[i], this.inputTransitionByChannelCounts[i]);
            if (!active) continue;
            channel.computeSynchronizations(configuration, this.outputTransitionsByChannels[i], this.outputTransitionByChannelCounts[i], this.inputTransitionsByChannels[i], this.inputTransitionByChannelCounts[i], executer);
            synchronizationExecuted = true;
        }
        Arrays.fill(this.inputTransitionByChannelCounts, 0);
        Arrays.fill(this.outputTransitionByChannelCounts, 0);
        return synchronizationExecuted;
    }
}

