/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractFoldingExplorer<C> {
    private Set<C> known = new HashSet<C>();
    private List<C> toSee = new LinkedList<C>();
    private Collection<C> result = new HashSet<C>();

    public abstract boolean checkFoldingPredicate(C var1);

    public abstract Collection<C> getTargets(C var1);

    public Set<C> getKnown() {
        return this.known;
    }

    public void setKnown(Set<C> known) {
        this.known = known;
    }

    public List<C> getToSee() {
        return this.toSee;
    }

    public void setToSee(List<C> toSee) {
        this.toSee = toSee;
    }

    public Collection<C> getResult() {
        return this.result;
    }

    public void setResult(Collection<C> result) {
        this.result = result;
    }

    public void setInitialConfiguration(C initialConfiguration) {
        if (!this.known.isEmpty() || !this.toSee.isEmpty()) {
            throw new IllegalStateException();
        }
        this.known.add(initialConfiguration);
        this.toSee.add(initialConfiguration);
    }

    public boolean exploreOneStep() {
        if (this.toSee.isEmpty()) {
            return false;
        }
        C source = this.toSee.remove(0);
        if (!this.checkFoldingPredicate(source)) {
            this.result.add(source);
            return true;
        }
        Collection<C> targets = this.getTargets(source);
        for (C configuration : targets) {
            if (!this.known.add(configuration)) continue;
            this.toSee.add(configuration);
        }
        return true;
    }

    public void explore() {
        this.result.clear();
        while (this.exploreOneStep()) {
        }
        this.known.clear();
        this.toSee.clear();
    }
}

