/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.printer;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDEvent;
import fr.ensta.aefd.toolbox.tools.printer.AEFDTXTPrinter;

public class ExtendedAEFDTXTPrinter
extends AEFDTXTPrinter {
    @Override
    public void visitTrigger(AEFDBooleanExpression.Trigger trigger) {
        this.boolExpStack.add("receive " + trigger.getFunctionalEntity().getIdentifier());
    }

    @Override
    public void visitEvent(AEFDEvent event) {
        this.boolExpStack.clear();
        event.getBoolExp().accept(this);
        if (this.boolExpStack.isEmpty() || ((String)this.boolExpStack.getFirst()).equals(AEFDBooleanExpression.TRUE)) {
            this.append("none");
        } else {
            this.append((String)this.boolExpStack.removeFirst());
        }
        this.appendLn(" Evenement");
    }

    @Override
    public void visitVariableEvaluation(AEFDBooleanExpression.VariableEvaluation variableEvaluation) {
        this.boolExpStack.add(variableEvaluation.getBooleanVariable().getName() + "==" + variableEvaluation.getExpectedValue());
    }

    @Override
    public void visitActionSequence(AEFDActionSequence actionSequence) {
        boolean first = true;
        for (AEFDAction action : actionSequence.getActionList()) {
            if (!first) {
                this.append("; ");
            }
            action.accept(this);
            if (!first) continue;
            first = false;
        }
        if (!first) {
            this.append("; ");
        }
        this.appendLn("Action\n");
    }

    @Override
    public void visitAffectation(AEFDAction.Affectation affectation) {
        this.append(affectation.getVariable().getName() + ":=" + affectation.getNewValue());
    }

    @Override
    public void visitSendEvent(AEFDAction.SendEvent sendEvent) {
        this.append("send ");
        this.append(sendEvent.getFunctionalEntity().getIdentifier());
    }

    @Override
    public void visitProperty(AEFDAction.Property property) {
        this.append(property.getFunctionalEntity().getIdentifier());
        this.append(": ");
        this.append(property.getName());
    }
}

