/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.printer;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDCondition;
import fr.ensta.aefd.model.AEFDEvent;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelObject;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import java.util.LinkedList;

public class AEFDTXTPrinter
extends AEFDModelVisitor.Stub {
    private StringBuilder result;
    private String automateName;
    private String lastIdentifier;
    protected final LinkedList<String> boolExpStack = new LinkedList();
    private boolean currentExpectedValue;

    protected void append(String text) {
        this.result.append(text);
    }

    protected void appendLn(String text) {
        this.result.append(text).append("\n");
    }

    public void setAutomateName(String automateName) {
        this.automateName = automateName;
    }

    public String getString(AEFDModelObject modelObject) {
        this.result = new StringBuilder();
        modelObject.accept(this);
        if (modelObject instanceof AEFDFunctionalEntity) {
            return this.lastIdentifier;
        }
        return this.result.toString();
    }

    @Override
    public void visitModel(AEFDModel model) {
        for (AEFDAutomate automate : model.getAllAutomates()) {
            automate.accept(this);
        }
    }

    @Override
    public void visitAutomate(AEFDAutomate automate) {
        this.automateName = automate.getName();
        for (AEFDTransition transition : automate.getTransitionSet()) {
            transition.accept(this);
        }
    }

    @Override
    public void visitTransition(AEFDTransition transition) {
        this.appendLn(this.automateName);
        this.appendLn(transition.getPlaceSource());
        this.appendLn(transition.getPlaceTarget());
        transition.getEvent().accept(this);
        transition.getCondition().accept(this);
        transition.getAction().accept(this);
    }

    @Override
    public void visitFunctionalEntity(AEFDFunctionalEntity functionalEntity) {
        this.lastIdentifier = functionalEntity.getIdentifier();
    }

    @Override
    public void visitEvent(AEFDEvent event) {
        this.boolExpStack.clear();
        event.getBoolExp().accept(this);
        if (this.boolExpStack.isEmpty()) {
            this.append("none");
        } else {
            this.append(this.boolExpStack.removeFirst());
        }
        this.appendLn(" Evenement");
    }

    @Override
    public void visitCondition(AEFDCondition condition) {
        this.boolExpStack.clear();
        condition.getBoolExp().accept(this);
        if (this.boolExpStack.isEmpty()) {
            this.append("true");
        } else {
            this.append(this.boolExpStack.removeFirst());
        }
        this.appendLn(" Condition");
    }

    @Override
    public void visitConstant(AEFDBooleanExpression.Constant constant) {
        if (constant.getValue()) {
            this.boolExpStack.add("true");
        } else {
            this.boolExpStack.add("false");
        }
    }

    @Override
    public void visitTrigger(AEFDBooleanExpression.Trigger trigger) {
        this.boolExpStack.add(trigger.getFunctionalEntity().getIdentifier());
    }

    @Override
    public void visitVariableEvaluation(AEFDBooleanExpression.VariableEvaluation variableEvaluation) {
        this.currentExpectedValue = variableEvaluation.getExpectedValue();
        variableEvaluation.getBooleanVariable().accept(this);
        this.boolExpStack.add(this.lastIdentifier);
    }

    @Override
    public void visitVariable(AEFDBooleanVariable variable) {
        super.visitVariable(variable);
        this.lastIdentifier = variable.getName() + "_" + variable.getStringValue(this.currentExpectedValue);
    }

    @Override
    public void visitNot(AEFDBooleanExpression.Not not) {
        not.getExpression().accept(this);
        String expression = this.boolExpStack.removeLast();
        this.boolExpStack.add("NON (" + expression + ")");
    }

    @Override
    public void visitOr(AEFDBooleanExpression.Or or) {
        or.getLhs().accept(this);
        String lhs = this.boolExpStack.removeLast();
        or.getRhs().accept(this);
        String rhs = this.boolExpStack.removeLast();
        this.boolExpStack.add(lhs + " OU " + rhs);
    }

    @Override
    public void visitAnd(AEFDBooleanExpression.And and) {
        and.getLhs().accept(this);
        String lhs = this.boolExpStack.removeLast();
        and.getRhs().accept(this);
        String rhs = this.boolExpStack.removeLast();
        this.boolExpStack.add(lhs + " ET " + rhs);
    }

    @Override
    public void visitActionSequence(AEFDActionSequence actionSequence) {
        LinkedList<AEFDFunctionalEntity> functionalEntityList = new LinkedList<AEFDFunctionalEntity>();
        for (AEFDAction action : actionSequence.getActionList()) {
            if (functionalEntityList.contains(action.getFunctionalEntity())) continue;
            functionalEntityList.add(action.getFunctionalEntity());
        }
        for (int index = 0; index < functionalEntityList.size(); ++index) {
            this.append(((AEFDFunctionalEntity)functionalEntityList.get(index)).getIdentifier());
            if (index + 1 != functionalEntityList.size()) {
                this.append(",");
            }
            this.append(" ");
        }
        this.appendLn("Action");
    }
}

