/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.parser;

import fr.ensta.aefd.antlr.AEFDBaseListener;
import fr.ensta.aefd.antlr.AEFDParser;
import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDCondition;
import fr.ensta.aefd.model.AEFDEvent;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.parser.BooleanExpressionHelper;
import fr.ensta.aefd.toolbox.tools.parser.Parser;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.TerminalNode;

public class TXTListener
extends AEFDBaseListener {
    private final Parser parser;
    private final BooleanExpressionHelper bExpHelper = new BooleanExpressionHelper();
    private final LinkedList<AEFDBooleanExpression> boolExpStack = new LinkedList();
    private AEFDEvent lastEvent;
    private AEFDCondition lastCondition;
    private AEFDActionSequence lastAction;
    private boolean bExpEventMode = false;

    public TXTListener(Parser parser) {
        this.parser = parser;
    }

    public void exitBexpTrue(AEFDParser.BexpTrueContext ctx) {
        super.exitBexpTrue(ctx);
        this.boolExpStack.add(AEFDBooleanExpression.TRUE);
    }

    public void exitBexpFalse(AEFDParser.BexpFalseContext ctx) {
        super.exitBexpFalse(ctx);
        this.boolExpStack.add(AEFDBooleanExpression.FALSE);
    }

    public void exitBexpIdentifier(AEFDParser.BexpIdentifierContext ctx) {
        super.exitBexpIdentifier(ctx);
        AEFDFunctionalEntity functionalEntity = this.parser.references.getFunctionalEntity(ctx.IDENTIFIER().getText(), true);
        if (this.bExpEventMode) {
            this.boolExpStack.add(this.parser.getTrigger(functionalEntity));
        } else if (!functionalEntity.getPrefix().requiresSuffix() && this.bExpHelper.getTriggers(this.lastEvent.getBoolExp()).contains(functionalEntity)) {
            this.boolExpStack.addLast(AEFDBooleanExpression.TRUE);
        } else {
            AEFDBooleanVariable booleanVariable = this.parser.references.getBooleanVariable(functionalEntity);
            boolean expectedValue = booleanVariable.getBooleanValue(functionalEntity.getSuffix());
            this.boolExpStack.add(new AEFDBooleanExpression.VariableEvaluation(booleanVariable, expectedValue));
        }
    }

    public void exitBexpNot(AEFDParser.BexpNotContext ctx) {
        super.exitBexpNot(ctx);
        this.boolExpStack.add(new AEFDBooleanExpression.Not(this.boolExpStack.removeLast()));
    }

    public void exitBexpAnd(AEFDParser.BexpAndContext ctx) {
        super.exitBexpAnd(ctx);
        AEFDBooleanExpression rhs = this.boolExpStack.removeLast();
        AEFDBooleanExpression lhs = this.boolExpStack.removeLast();
        this.boolExpStack.add(new AEFDBooleanExpression.And(lhs, rhs));
    }

    public void exitBexpOr(AEFDParser.BexpOrContext ctx) {
        super.exitBexpOr(ctx);
        AEFDBooleanExpression rhs = this.boolExpStack.removeLast();
        AEFDBooleanExpression lhs = this.boolExpStack.removeLast();
        this.boolExpStack.add(new AEFDBooleanExpression.Or(lhs, rhs));
    }

    public void exitBexpEmptyParenthesis(AEFDParser.BexpEmptyParenthesisContext ctx) {
        super.exitBexpEmptyParenthesis(ctx);
        this.boolExpStack.add(AEFDBooleanExpression.TRUE);
    }

    public void enterEventDecl(AEFDParser.EventDeclContext ctx) {
        super.enterEventDecl(ctx);
        this.bExpEventMode = true;
    }

    public void exitEventDecl(AEFDParser.EventDeclContext ctx) {
        super.exitEventDecl(ctx);
        this.lastEvent = new AEFDEvent();
        if (this.boolExpStack.size() > 0) {
            this.lastEvent.setBoolExp(this.boolExpStack.removeLast());
        } else {
            this.lastEvent.setBoolExp(AEFDBooleanExpression.TRUE);
        }
    }

    public void enterConditionDecl(AEFDParser.ConditionDeclContext ctx) {
        super.enterConditionDecl(ctx);
        this.bExpEventMode = false;
    }

    public void exitConditionDecl(AEFDParser.ConditionDeclContext ctx) {
        super.exitConditionDecl(ctx);
        this.lastCondition = new AEFDCondition();
        if (this.boolExpStack.size() > 0) {
            this.lastCondition.setBoolExp(this.boolExpStack.removeLast());
        } else {
            this.lastCondition.setBoolExp(AEFDBooleanExpression.TRUE);
        }
    }

    public void exitActionDecl(AEFDParser.ActionDeclContext ctx) {
        super.exitActionDecl(ctx);
        this.lastAction = new AEFDActionSequence();
        for (TerminalNode node : ctx.IDENTIFIER()) {
            AEFDFunctionalEntity functionalEntity = this.parser.references.getFunctionalEntity(node.getText(), true);
            for (AEFDAction action : this.parser.getActionList(functionalEntity)) {
                this.lastAction.addAction(action);
            }
        }
    }

    public void exitTransitionDecl(AEFDParser.TransitionDeclContext ctx) {
        super.exitTransitionDecl(ctx);
        StringBuilder automateNameBuilder = new StringBuilder();
        for (TerminalNode node : ctx.IDENTIFIER()) {
            if (!automateNameBuilder.toString().equals("")) {
                automateNameBuilder.append("_");
            }
            automateNameBuilder.append(node.toString());
        }
        String automateName = automateNameBuilder.toString();
        String placeSource = ctx.NUMBER(0).getText();
        String placeTarget = ctx.NUMBER(1).getText();
        AEFDTransition transition = new AEFDTransition(placeSource, placeTarget);
        transition.setEvent(this.lastEvent);
        transition.setCondition(this.lastCondition);
        transition.setAction(this.lastAction);
        AEFDAutomate automate = this.parser.references.getAutomate(automateName, true);
        if (automate.getInitialPlace() == null || Integer.valueOf(automate.getInitialPlace()) > Integer.valueOf(placeSource)) {
            automate.setInitialPlace(placeSource);
        }
        automate.addTransition(transition);
    }
}

