/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.parser;

import fr.ensta.aefd.antlr.AEFDLexer;
import fr.ensta.aefd.antlr.AEFDParser;
import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDPrefix;
import fr.ensta.aefd.model.meta.ModelReferences;
import fr.ensta.aefd.toolbox.tools.handler.ModelHandles;
import fr.ensta.aefd.toolbox.tools.parser.DCOListener;
import fr.ensta.aefd.toolbox.tools.parser.TXTListener;
import fr.ensta.dco.antlr.DCOLexer;
import fr.ensta.dco.antlr.DCOParser;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Parser {
    public final AEFDModel model;
    public final ModelHandles handles;
    public final ModelReferences references;
    private final List<String> fileNames;
    private final List<String> parsedFileNames;
    private final TXTListener txtListener;
    private final DCOListener dcoListener;
    private final Map<AEFDFunctionalEntity, List<AEFDAction>> actionListMap = new HashMap<AEFDFunctionalEntity, List<AEFDAction>>();
    private static final String WARNING = "Warning";
    private static final String CUT = "Cut";
    private static final String REJECT = "Reject";
    private static final String UNKNOWN = "Unknown";
    private final Map<String, AEFDBooleanExpression.Trigger> triggerMap = new HashMap<String, AEFDBooleanExpression.Trigger>();

    public Parser(AEFDModel model, ModelHandles handles, ModelReferences references) {
        if (model == null) {
            this.model = new AEFDModel();
            this.handles = new ModelHandles(model);
            this.references = new ModelReferences(model);
        } else {
            this.model = model;
            this.handles = handles == null ? new ModelHandles(model) : handles;
            this.references = references == null ? new ModelReferences(model) : references;
        }
        this.fileNames = new LinkedList<String>();
        this.parsedFileNames = new LinkedList<String>();
        this.txtListener = new TXTListener(this);
        this.dcoListener = new DCOListener(this);
    }

    public Parser() {
        this(null, null, null);
    }

    public void addFile(String fileName) {
        if (this.fileNames.contains(fileName)) {
            return;
        }
        this.fileNames.add(fileName);
        this.handles.log("Added file: " + fileName);
    }

    private void parseOneFile(String fileName) throws Exception {
        this.addFile(fileName);
        if (this.parsedFileNames.contains(fileName)) {
            return;
        }
        String extension = fileName.substring(fileName.length() - 3);
        if (extension.equals("txt")) {
            AEFDLexer lexer = new AEFDLexer((CharStream)new ANTLRFileStream(fileName, "UTF-8"));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            AEFDParser parser = new AEFDParser((TokenStream)tokens);
            AEFDParser.ModelDeclContext tree = parser.modelDecl();
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk((ParseTreeListener)this.txtListener, (ParseTree)tree);
        } else if (extension.equals("dco")) {
            DCOLexer lexer = new DCOLexer((CharStream)new ANTLRFileStream(fileName, "UTF-8"));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            DCOParser parser = new DCOParser((TokenStream)tokens);
            DCOParser.ModelDeclContext tree = parser.modelDecl();
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk((ParseTreeListener)this.dcoListener, (ParseTree)tree);
        } else {
            throw new IllegalArgumentException("Unsupported extension : " + extension);
        }
        this.parsedFileNames.add(fileName);
        this.handles.log("Parsed " + fileName);
    }

    public AEFDModel parse(String fileName) throws Exception {
        this.parseOneFile(fileName);
        this.finalizedModel();
        this.handles.logPrettyPrint();
        return this.model;
    }

    public AEFDModel parse() throws Exception {
        for (String fileName : this.fileNames) {
            this.parseOneFile(fileName);
        }
        this.finalizedModel();
        this.handles.logPrettyPrint();
        return this.model;
    }

    private void finalizedModel() {
        this.references.addMissingVariableLinks();
        this.references.addMissingFunctionalEntities();
    }

    public List<AEFDAction> getActionList(AEFDFunctionalEntity functionalEntity) {
        List<AEFDAction> actionList = this.actionListMap.get(functionalEntity);
        if (actionList == null) {
            actionList = new LinkedList<AEFDAction>();
            AEFDPrefix prefix = functionalEntity.getPrefix();
            if (prefix.requiresSuffix()) {
                AEFDBooleanVariable booleanVariable = this.references.getBooleanVariable(functionalEntity);
                if (this.references.getVariable(functionalEntity) == null) {
                    this.references.linkVariable(functionalEntity, booleanVariable);
                }
                boolean newValue = booleanVariable.getBooleanValue(functionalEntity.getSuffix());
                AEFDAction.Affectation affectation = new AEFDAction.Affectation(booleanVariable, newValue);
                affectation.setFunctionalEntity(functionalEntity);
                actionList.add(affectation);
            } else if (prefix.equals((Object)AEFDPrefix.P)) {
                String name = this.getPropertyName(functionalEntity);
                AEFDAction.Property property = new AEFDAction.Property(name);
                property.setFunctionalEntity(functionalEntity);
                actionList.add(property);
            }
            AEFDAction.SendEvent sendEvent = new AEFDAction.SendEvent();
            sendEvent.setFunctionalEntity(functionalEntity);
            actionList.add(sendEvent);
            this.actionListMap.put(functionalEntity, actionList);
        }
        return actionList;
    }

    public String getPropertyName(AEFDFunctionalEntity functionalEntity) {
        String identifier = functionalEntity.getIdentifier();
        if (identifier.equals("P_5")) {
            return REJECT;
        }
        if (identifier.equals("P_6")) {
            return CUT;
        }
        if (identifier.equals("P_7")) {
            return WARNING;
        }
        return UNKNOWN;
    }

    public AEFDBooleanExpression.Trigger getTrigger(AEFDFunctionalEntity functionalEntity) {
        AEFDBooleanExpression.Trigger result = this.triggerMap.get(functionalEntity.getIdentifier());
        if (result == null) {
            result = new AEFDBooleanExpression.Trigger(functionalEntity);
            this.triggerMap.put(functionalEntity.getIdentifier(), result);
        }
        return result;
    }
}

