/*
 * Decompiled with CFR 0.152.
 */
package obp.transfo.cc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;

public class ConcreteContextCache {
    private final ConcreteContext cc;
    private final HashMap<State, List<Transition>> inTransitionMap;
    private final HashMap<State, List<Transition>> outTransitionMap;

    public ConcreteContextCache(ConcreteContext cc) {
        this.cc = cc;
        this.inTransitionMap = new HashMap();
        this.outTransitionMap = new HashMap();
        this.inTransitionMap.put(cc.getStartState(), new ArrayList());
        this.outTransitionMap.put(cc.getStartState(), new ArrayList());
        for (State state : cc.getStateList()) {
            this.inTransitionMap.put(state, new ArrayList());
            this.outTransitionMap.put(state, new ArrayList());
        }
        for (Transition transition : cc.getTransitionList()) {
            this.inTransitionMap.get(transition.getTarget()).add(transition);
            this.outTransitionMap.get(transition.getSource()).add(transition);
        }
    }

    public ConcreteContext getConcreteContext() {
        return this.cc;
    }

    public List<Transition> getInTransitions(State target) {
        return this.inTransitionMap.get(target);
    }

    public List<Transition> getOutTransitions(State source) {
        return this.outTransitionMap.get(source);
    }
}

