/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.Action;
import obp.simulation.model.Previous;

public class SimulatedConfiguration {
    private Configuration configuration;
    private Map<Transition, Configuration> LTS;
    private Map<Integer, Previous> previousConfigMap;
    private boolean previousSet = false;
    private int previous = 0;

    public SimulatedConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.LTS = new HashMap<Transition, Configuration>();
        this.previousConfigMap = new HashMap<Integer, Previous>();
    }

    public void addToLTS(Transition transition, Configuration configuration) {
        this.LTS.put(transition, configuration);
    }

    public void addPreviousConfig(Configuration configuration, Action action, String toFire) {
        if (!this.previousConfigMap.containsKey(configuration.id)) {
            this.previousConfigMap.put(configuration.id, new Previous(configuration.id, action, toFire));
            this.previous = this.previousConfigMap.size() - 1;
            this.previousSet = false;
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Previous getPreviousConfiguration() {
        Previous previousConfig = null;
        if (!this.previousSet) {
            Iterator<Map.Entry<Integer, Previous>> previousIt = this.previousConfigMap.entrySet().iterator();
            while (previousIt.hasNext()) {
                previousConfig = previousIt.next().getValue();
            }
        } else {
            previousConfig = (Previous)this.previousConfigMap.values().toArray()[this.previous];
        }
        return previousConfig;
    }

    public Map<Transition, Configuration> getLTS() {
        return this.LTS;
    }

    public int nbPrevious() {
        return this.previousConfigMap.size();
    }

    public Map<Integer, Previous> getPreviousList() {
        return this.previousConfigMap;
    }

    public void switchPrevious() {
        if (this.previousSet) {
            ++this.previous;
        }
        if (this.previous > this.previousConfigMap.size() - 1) {
            this.previous = 0;
        }
        this.previousSet = true;
    }

    public void setPrevious(int previousId) {
        if (this.previousConfigMap.containsKey(previousId)) {
            Iterator<Map.Entry<Integer, Previous>> previousIt = this.previousConfigMap.entrySet().iterator();
            int i = 0;
            while (previousIt.hasNext()) {
                if (previousId == previousIt.next().getKey()) {
                    this.previous = i;
                    this.previousSet = false;
                }
                ++i;
            }
        }
    }
}

