/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import obp.interpreter.runtime.EventImpl;

public class EventUtil {
    public static EventImpl get(EventImpl[] events, int index) {
        return events[index];
    }

    public static EventImpl first(EventImpl[] events) {
        if (events.length == 0) {
            return EventImpl.NIL;
        }
        return events[0];
    }

    public static EventImpl first(EventImpl[] events, short behaviorId) {
        for (int i = 0; i < events.length; ++i) {
            if (events[i].destinationId != behaviorId) continue;
            return events[i];
        }
        return EventImpl.NIL;
    }

    public static EventImpl last(EventImpl[] events) {
        if (events.length == 0) {
            return EventImpl.NIL;
        }
        return events[events.length - 1];
    }

    public static EventImpl last(EventImpl[] events, short behaviorId) {
        for (int i = events.length - 1; i >= 0; --i) {
            if (events[i].destinationId != behaviorId) continue;
            return events[i];
        }
        return EventImpl.NIL;
    }

    public static EventImpl[] add(EventImpl[] events, int index, EventImpl event) {
        int i;
        EventImpl[] newEvents = new EventImpl[events.length + 1];
        for (i = 0; i < index; ++i) {
            newEvents[i] = events[i];
        }
        newEvents[index] = event;
        for (i = index + 1; i < newEvents.length; ++i) {
            newEvents[i] = events[i - 1];
        }
        return newEvents;
    }

    public static EventImpl[] addFirst(EventImpl[] events, EventImpl event) {
        return EventUtil.add(events, 0, event);
    }

    public static EventImpl[] addLast(EventImpl[] events, EventImpl event) {
        return EventUtil.add(events, events.length, event);
    }

    public static EventImpl[] remove(EventImpl[] events, int index) {
        int i;
        if (events.length <= 1) {
            return new EventImpl[0];
        }
        EventImpl[] newEvents = new EventImpl[events.length - 1];
        for (i = 0; i < index; ++i) {
            newEvents[i] = events[i];
        }
        for (i = index; i < newEvents.length; ++i) {
            newEvents[i] = events[i + 1];
        }
        return newEvents;
    }

    public static EventImpl[] removeFirst(EventImpl[] events) {
        return EventUtil.remove(events, 0);
    }

    public static EventImpl[] removeFirst(EventImpl[] events, short behaviorId) {
        for (int i = 0; i < events.length; ++i) {
            if (events[i].destinationId != behaviorId) continue;
            return EventUtil.remove(events, i);
        }
        return events;
    }

    public static EventImpl[] removeLast(EventImpl[] events) {
        return EventUtil.remove(events, events.length - 1);
    }

    public static EventImpl[] removeLast(EventImpl[] events, short behaviorId) {
        for (int i = events.length - 1; i >= 0; --i) {
            if (events[i].destinationId != behaviorId) continue;
            return EventUtil.remove(events, i);
        }
        return events;
    }
}

