/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.analysis.basic.ReadVariablesAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.basic.WrittenVariablesAnalysis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VariableDependenciesAnalysis {
    private final ReadVariablesAnalysis readVariables = new ReadVariablesAnalysis();
    private final WrittenVariablesAnalysis writtenVariables = new WrittenVariablesAnalysis();
    private Set<Simple> simpleDependencies = new HashSet<Simple>();
    private Set<EventSpecific> specificDependencies = new HashSet<EventSpecific>();
    private Map<AEFDAutomate, Set<AEFDAutomate>> simpleFanout = new HashMap<AEFDAutomate, Set<AEFDAutomate>>();
    private Map<AEFDAutomate, Set<AEFDAutomate>> specificFanout = new HashMap<AEFDAutomate, Set<AEFDAutomate>>();

    public void analyse(AEFDModel model) {
        this.readVariables.analyze(model);
        this.writtenVariables.analyze(model);
        this.simpleDependencies.clear();
        this.specificDependencies.clear();
        for (AEFDBooleanVariable variable : model.getAllVariables()) {
            for (AEFDAutomate reader : this.readVariables.getReaders(variable)) {
                for (AEFDAutomate writer : this.writtenVariables.getWriters(variable)) {
                    this.simpleDependencies.add(new Simple(variable, reader, writer));
                }
            }
            for (AEFDFunctionalEntity event : model.getAllFunctionalEntity()) {
                for (AEFDAutomate reader : this.readVariables.getReaders(variable)) {
                    for (AEFDAutomate writer : this.writtenVariables.getWriters(variable)) {
                        this.specificDependencies.add(new EventSpecific(variable, reader, writer, event));
                    }
                }
            }
        }
        VariableDependenciesAnalysis.computeFanout(this.simpleFanout, model, this.simpleDependencies);
        VariableDependenciesAnalysis.computeFanout(this.specificFanout, model, this.specificDependencies);
    }

    private static void computeFanout(Map<AEFDAutomate, Set<AEFDAutomate>> fanout, AEFDModel model, Set<? extends Simple> dependencies) {
        fanout.clear();
        for (AEFDAutomate aEFDAutomate : model.getAllAutomates()) {
            fanout.put(aEFDAutomate, new HashSet());
        }
        for (Simple simple : dependencies) {
            fanout.get(simple.reader).add(simple.writer);
        }
    }

    private class EventSpecific
    extends Simple {
        public AEFDFunctionalEntity event;

        public EventSpecific(AEFDBooleanVariable variable, AEFDAutomate reader, AEFDAutomate writer, AEFDFunctionalEntity event) {
            super(variable, reader, writer);
            this.event = event;
        }
    }

    private class Simple {
        public AEFDBooleanVariable variable;
        public AEFDAutomate reader;
        public AEFDAutomate writer;

        public Simple(AEFDBooleanVariable variable, AEFDAutomate reader, AEFDAutomate writer) {
            this.variable = variable;
            this.reader = reader;
            this.writer = writer;
        }
    }
}

