/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDEvent;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RawModelValidation
extends AEFDModelVisitor.Stub {
    private AEFDModel model;
    private List<Issue> issues = new LinkedList<Issue>();
    private AEFDAutomate currentAutomate;
    private AEFDTransition currentTransition;
    private boolean atLeastOneTrigger = false;

    public void analyse(AEFDModel model) {
        this.model = model;
        this.issues.clear();
        model.accept(this);
    }

    public boolean isValid() {
        return this.issues.isEmpty();
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public String getShortReport() {
        if (this.issues.isEmpty()) {
            return "Model is valid (no issue to list)\n";
        }
        HashMap<String, Integer> commentMap = new HashMap<String, Integer>();
        for (Issue issue : this.issues) {
            Integer count = (Integer)commentMap.get(issue.getComment());
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            commentMap.put(issue.getComment(), count);
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : commentMap.entrySet()) {
            result.append(entry.getValue()).append(" times: '").append((String)entry.getKey()).append("'\n");
        }
        return result.toString();
    }

    private void logIssue(String comment) {
        this.issues.add(new Issue(this.currentAutomate, this.currentTransition, comment));
    }

    @Override
    public void visitModel(AEFDModel model) {
        Iterator iterator = model.getAllAutomates().iterator();
        while (iterator.hasNext()) {
            AEFDAutomate automate;
            this.currentAutomate = automate = (AEFDAutomate)iterator.next();
            automate.accept(this);
        }
    }

    @Override
    public void visitAutomate(AEFDAutomate automate) {
        Iterator<AEFDTransition> iterator = automate.getTransitionSet().iterator();
        while (iterator.hasNext()) {
            AEFDTransition transition;
            this.currentTransition = transition = iterator.next();
            transition.accept(this);
        }
    }

    @Override
    public void visitTransition(AEFDTransition transition) {
        this.atLeastOneTrigger = false;
        transition.getEvent().accept(this);
        if (!this.atLeastOneTrigger) {
            this.logIssue("Missing a trigger event");
        }
    }

    @Override
    public void visitEvent(AEFDEvent event) {
        event.getBoolExp().accept(this);
    }

    @Override
    public void visitConstant(AEFDBooleanExpression.Constant constant) {
        this.logIssue("Boolean constant found in event field");
    }

    @Override
    public void visitTrigger(AEFDBooleanExpression.Trigger trigger) {
        this.atLeastOneTrigger = true;
    }

    @Override
    public void visitVariableEvaluation(AEFDBooleanExpression.VariableEvaluation variableEvaluation) {
        throw new IllegalArgumentException("Valuation of a variable in event field (error while loading model)");
    }

    @Override
    public void visitNot(AEFDBooleanExpression.Not not) {
        this.logIssue("Boolean operator 'not' found in event field");
        not.getExpression().accept(this);
    }

    @Override
    public void visitOr(AEFDBooleanExpression.Or or) {
        or.getLhs().accept(this);
        or.getRhs().accept(this);
    }

    @Override
    public void visitAnd(AEFDBooleanExpression.And and) {
        this.logIssue("Boolean operator 'and' found in event field");
        and.getLhs().accept(this);
        and.getLhs().accept(this);
    }

    public static class Issue {
        private final AEFDAutomate automate;
        private final AEFDTransition transition;
        private final String comment;

        public Issue(AEFDAutomate automate, AEFDTransition transition, String comment) {
            this.automate = automate;
            this.transition = transition;
            this.comment = comment;
        }

        public AEFDAutomate getAutomate() {
            return this.automate;
        }

        public AEFDTransition getTransition() {
            return this.transition;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

