/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.demos;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;

public class Temporary {
    private static final int MAX_S = 20;
    private static final int MAX_R = 20;
    private static final int MAX_STATES = 2173248;
    private static final String END_OF_SECTION = "\n-----\n\n";

    private static String getSettingsString() {
        StringBuilder settingsString = new StringBuilder();
        settingsString.append("Max number of sensors : ").append(20).append("\n");
        settingsString.append("Max number of relays  : ").append(20).append("\n");
        settingsString.append("Max explorable state space : ").append(2173248).append("\n");
        return settingsString.toString();
    }

    private static String getFullReport(List<Formula> formulaList, boolean shortStory) {
        StringBuilder fullReport = new StringBuilder();
        fullReport.append(Temporary.getSettingsString());
        fullReport.append(END_OF_SECTION);
        for (Formula formula : formulaList) {
            fullReport.append(formula.getReportString(shortStory));
            fullReport.append(END_OF_SECTION);
        }
        return fullReport.toString();
    }

    public static void main(String[] args) {
        LinkedList<Formula> formulaList = new LinkedList<Formula>();
        formulaList.add(new Formula("Raw", "2^s * (2*s + 1)^(r + 1)", (s, r) -> Math.pow(2.0, s.intValue()) * Math.pow(2 * s + 1, r + 1)));
        formulaList.add(new Formula("Reactivity", "2^s * (2*s*(r+1) + 1)", (s, r) -> Math.pow(2.0, s.intValue()) * (double)(2 * s * (r + 1) + 1)));
        formulaList.add(new Formula("Folding", "2^s", (s, r) -> Math.pow(2.0, s.intValue())));
        System.out.println(Temporary.getFullReport(formulaList, false));
    }

    private static class Formula {
        public final String name;
        public final String string;
        public final BiFunction<Integer, Integer, Double> function;

        public Formula(String name, String string, BiFunction<Integer, Integer, Double> function) {
            this.name = name;
            this.string = string;
            this.function = function;
        }

        public String getReportString(boolean shortStory) {
            int s;
            int[] success = new int[20];
            Arrays.fill(success, 0);
            StringBuilder reportString = new StringBuilder();
            reportString.append(this.name).append(" formula : ").append(this.string).append("\n");
            for (s = 1; s <= 20; ++s) {
                for (int r = 1; r <= 20; ++r) {
                    double n = this.function.apply(s, r);
                    if (n <= 2173248.0) {
                        success[s - 1] = r;
                    }
                    if (shortStory) continue;
                    reportString.append("s = ").append(s).append(", r = ").append(r).append(", ").append(n).append(" configurations\n");
                }
            }
            reportString.append("\nSuccessful explorations ");
            if (!shortStory) {
                reportString.append("(").append(this.name).append(")");
            }
            reportString.append(":\n");
            for (s = 1; s <= 20; ++s) {
                if (success[s - 1] <= 0) continue;
                reportString.append("s = ").append(s).append(", r = [1-").append(success[s - 1]).append("]\n");
            }
            return reportString.toString();
        }
    }
}

