/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.transform;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.model.meta.ModelReferences;
import fr.ensta.aefd.toolbox.tools.handler.ModelHandles;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MoveEventToInit
extends AEFDModelVisitor.Stub {
    private AEFDModel model;
    private ModelReferences references;
    private ModelHandles handles;
    private AEFDAutomate environment;
    private AEFDFunctionalEntity event;
    private AEFDTransition currentTransition;
    private AEFDTransition toMoveUp;
    private LinkedList<String> stateSeq;
    private String nextStateName;
    private boolean silentMoveUp = false;
    private boolean changed = false;

    public void load(AEFDModel model, ModelReferences references, ModelHandles handles) {
        this.model = model;
        this.handles = handles;
        references.synchronizeUsed();
        this.environment = references.getAutomate("Environment");
        if (this.environment == null) {
            throw new IllegalStateException("Couldn't load environment from the model");
        }
        this.stateSeq = new LinkedList();
        this.stateSeq.add(this.environment.getInitialPlace());
    }

    public void moveUp(AEFDFunctionalEntity event) {
        this.event = event;
        if (!this.silentMoveUp) {
            this.changed = false;
        }
        this.toMoveUp = null;
        Iterator<AEFDTransition> iterator = this.environment.getTransitionSet().iterator();
        while (iterator.hasNext()) {
            AEFDTransition transition;
            this.currentTransition = transition = iterator.next();
            this.addStates();
            if (this.toMoveUp != null) continue;
            transition.getAction().accept(this);
        }
        if (this.toMoveUp != null) {
            this.changed = true;
            this.computeNextStateName();
            this.changeTargets(this.toMoveUp.getPlaceSource().intern(), this.nextStateName.intern());
            this.toMoveUp.setPlaceTarget(this.toMoveUp.getPlaceSource());
            this.toMoveUp.setPlaceSource(this.nextStateName.intern());
            this.environment.getPlaceSet().add(this.nextStateName.intern());
            this.handles.log("In Environment, " + event.getIdentifier() + " moved to init phase.");
            this.updateInitialPlace();
            if (!this.silentMoveUp) {
                this.handles.logPrettyPrint();
            }
        }
    }

    public void moveUp(List<AEFDFunctionalEntity> eventSeq) {
        this.changed = false;
        this.silentMoveUp = true;
        for (AEFDFunctionalEntity event : eventSeq) {
            this.moveUp(event);
        }
        this.silentMoveUp = false;
        if (this.changed) {
            this.handles.logPrettyPrint();
        }
    }

    private void updateInitialPlace() {
        int newIndex = this.stateSeq.indexOf(this.toMoveUp.getPlaceTarget().intern());
        this.stateSeq.add(newIndex, this.nextStateName);
        String newInitialPlace = this.stateSeq.getFirst().intern();
        if (this.environment.getInitialPlace() != newInitialPlace) {
            this.environment.setInitialPlace(this.stateSeq.getFirst().intern());
            this.handles.log("Environment new initial place: " + newInitialPlace);
        }
    }

    private void addStates() {
        if (!this.stateSeq.contains(this.currentTransition.getPlaceSource().intern())) {
            this.stateSeq.addLast(this.currentTransition.getPlaceSource().intern());
        }
        if (!this.stateSeq.contains(this.currentTransition.getPlaceTarget().intern())) {
            int sourceIndex = this.stateSeq.indexOf(this.currentTransition.getPlaceSource().intern());
            this.stateSeq.add(sourceIndex + 1, this.currentTransition.getPlaceTarget().intern());
        }
    }

    private void computeNextStateName() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            this.nextStateName = Integer.toString(i).intern();
            if (!this.stateSeq.contains(this.nextStateName)) break;
        }
    }

    private void changeTargets(String oldTarget, String newTarget) {
        for (AEFDTransition transition : this.environment.getTransitionSet()) {
            if (transition == this.toMoveUp || transition.getPlaceSource().equals(oldTarget) || !transition.getPlaceTarget().equals(oldTarget)) continue;
            transition.setPlaceTarget(newTarget);
        }
    }

    @Override
    public void visitActionSequence(AEFDActionSequence actionSequence) {
        for (AEFDAction action : actionSequence.getActionList()) {
            action.accept(this);
        }
    }

    @Override
    public void visitSendEvent(AEFDAction.SendEvent sendEvent) {
        if (sendEvent.getFunctionalEntity() == this.event) {
            this.toMoveUp = this.currentTransition;
        }
    }

    @Override
    public void visitAffectation(AEFDAction.Affectation affectation) {
        if (affectation.getFunctionalEntity() == this.event) {
            this.toMoveUp = this.currentTransition;
        }
    }
}

