/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.interpreter.IBehavior;
import obp.interpreter.InterpreterVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class IProgram
implements BoostObject {
    private String name;
    private String init;
    private final List<String> eventList = new ArrayList<String>();
    private final List<String> informalList = new ArrayList<String>();
    private final List<IBehavior> behaviorList = new ArrayList<IBehavior>();

    public IProgram() {
    }

    protected IProgram(Boost boost) {
        boost.register((BoostObject)this);
        this.name = boost.readString();
        this.init = boost.readString();
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.eventList.add(oneChild);
        }
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.informalList.add(oneChild);
        }
        for (IBehavior oneChild : BoostUtil.readObjectList((Boost)boost, IBehavior.class)) {
            this.behaviorList.add(oneChild);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    public String getInit() {
        return this.init;
    }

    public void setInit(String newValue) {
        if (this.init == null ? newValue != null : !this.init.equals(newValue)) {
            this.init = newValue;
        }
    }

    public List<String> getEventList() {
        return Collections.unmodifiableList(this.eventList);
    }

    public int getEventCount() {
        return this.eventList.size();
    }

    public String getEvent(int index) {
        if (index < 0 || index >= this.getEventCount()) {
            return null;
        }
        return this.eventList.get(index);
    }

    public void addEvent(String newValue) {
        this.addEvent(this.getEventCount(), newValue);
    }

    public void addEvent(int index, String newValue) {
        this.eventList.add(index, newValue);
    }

    public String setEvent(int index, String newValue) {
        return this.eventList.set(index, newValue);
    }

    public void addAllEvent(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addEvent(this.getEventCount(), newValue);
        }
    }

    public void removeEvent(String value) {
        int index = this.eventList.indexOf(value);
        if (index >= 0) {
            this.removeEvent(index);
        }
    }

    public void removeEvent(int index) {
        this.eventList.remove(index);
    }

    public List<String> getInformalList() {
        return Collections.unmodifiableList(this.informalList);
    }

    public int getInformalCount() {
        return this.informalList.size();
    }

    public String getInformal(int index) {
        if (index < 0 || index >= this.getInformalCount()) {
            return null;
        }
        return this.informalList.get(index);
    }

    public void addInformal(String newValue) {
        this.addInformal(this.getInformalCount(), newValue);
    }

    public void addInformal(int index, String newValue) {
        this.informalList.add(index, newValue);
    }

    public String setInformal(int index, String newValue) {
        return this.informalList.set(index, newValue);
    }

    public void addAllInformal(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addInformal(this.getInformalCount(), newValue);
        }
    }

    public void removeInformal(String value) {
        int index = this.informalList.indexOf(value);
        if (index >= 0) {
            this.removeInformal(index);
        }
    }

    public void removeInformal(int index) {
        this.informalList.remove(index);
    }

    public List<IBehavior> getBehaviorList() {
        return Collections.unmodifiableList(this.behaviorList);
    }

    public int getBehaviorCount() {
        return this.behaviorList.size();
    }

    public IBehavior getBehavior(int index) {
        if (index < 0 || index >= this.getBehaviorCount()) {
            return null;
        }
        return this.behaviorList.get(index);
    }

    public void addBehavior(IBehavior newValue) {
        this.addBehavior(this.getBehaviorCount(), newValue);
    }

    public void addBehavior(int index, IBehavior newValue) {
        this.behaviorList.add(index, newValue);
    }

    public IBehavior setBehavior(int index, IBehavior newValue) {
        return this.behaviorList.set(index, newValue);
    }

    public void addAllBehavior(Collection<IBehavior> toAddList) {
        for (IBehavior newValue : toAddList) {
            this.addBehavior(this.getBehaviorCount(), newValue);
        }
    }

    public void removeBehavior(IBehavior value) {
        int index = this.behaviorList.indexOf(value);
        if (index >= 0) {
            this.removeBehavior(index);
        }
    }

    public void removeBehavior(int index) {
        this.behaviorList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeString(this.name);
        boost.writeString(this.init);
        BoostUtil.writeStringCollection((Boost)boost, this.eventList);
        BoostUtil.writeStringCollection((Boost)boost, this.informalList);
        BoostUtil.writeObjectCollection((Boost)boost, this.behaviorList);
    }

    public void accept(InterpreterVisitor visitor) {
        visitor.visitIProgram(this);
    }
}

