/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.Map;
import java.util.Stack;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.type.CAny;
import obp.fiacre.checker.type.CArray;
import obp.fiacre.checker.type.CBool;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.checker.type.CInt;
import obp.fiacre.checker.type.CQueue;
import obp.fiacre.checker.type.CRecord;
import obp.fiacre.checker.type.CType;
import obp.fiacre.checker.type.CTypeUtil;
import obp.fiacre.checker.type.CUnion;
import obp.fiacre.checker.type.ExpCTypeInferrer;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.CondExp;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ExternalFunctionRef;
import obp.fiacre.model.FunctionRef;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.PatternExp;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;
import obp.fiacre.util.TypeUtil;

public class ExpressionGenerator
extends ModelVisitor.Stub {
    private final ExpCTypeInferrer inferrer = new ExpCTypeInferrer();
    private final ProgramGenerator caller;
    private StringBuilder java;
    private Stack<CType> typeStack;
    private Mode generationMode;

    public ExpressionGenerator(ProgramGenerator caller) {
        this.caller = caller;
    }

    public Map<Type, String> getTypeNames() {
        return this.caller.getTypeNames();
    }

    private void init(CType type) {
        this.java = new StringBuilder();
        this.typeStack = new Stack();
        this.pushType(type);
    }

    public String generateForBehavior(CType type, Exp exp) {
        this.generationMode = Mode.Behavior;
        this.init(type);
        exp.accept(this);
        return this.java.toString();
    }

    public String generateForFunction(CType type, Exp exp) {
        this.generationMode = Mode.Function;
        this.init(type);
        exp.accept(this);
        return this.java.toString();
    }

    public String generateForComposition(CType type, Exp exp) {
        this.generationMode = Mode.Composition;
        this.init(type);
        exp.accept(this);
        return this.java.toString();
    }

    private boolean isSharedVariable(Exp exp) {
        if (exp instanceof VarRef) {
            Variable decl = ((VarRef)exp).getDecl();
            if (decl instanceof ArgumentVariable) {
                return ((ArgumentVariable)decl).isRef();
            }
        } else if (exp instanceof RecordElem) {
            return this.isSharedVariable(((RecordElem)exp).getRecord());
        }
        return false;
    }

    @Override
    public void visitUnExp(UnExp toVisit) {
        this.java.append(" ");
        switch (toVisit.getUnop()) {
            case UEMPTY: {
                this.pushType(new CQueue(CAny.anyType));
                this.java.append("(");
                toVisit.getExp().accept(this);
                this.java.append(".length == 0)");
                this.popType();
                break;
            }
            case LENGTH: {
                this.pushType(new CQueue(CAny.anyType));
                this.java.append("(");
                toVisit.getExp().accept(this);
                this.java.append(".length)");
                this.popType();
                break;
            }
            case FIRST: {
                this.pushType(new CQueue(this.peekType()));
                this.caller.getDependencyManager().getShortName("obp.explorer.runtime.fiacre.FiacreQueueUtil");
                this.java.append("FiacreQueueUtil.first(");
                toVisit.getExp().accept(this);
                this.java.append(")");
                this.popType();
                break;
            }
            case UFULL: {
                CType found = this.inferrer.infer(toVisit.getExp()).resolve();
                if (!(found instanceof CQueue)) {
                    throw new IllegalArgumentException("Type '" + found + "' isn't a 'CQueue'.");
                }
                CQueue queueFound = (CQueue)found;
                this.pushType(found);
                this.java.append("(");
                toVisit.getExp().accept(this);
                this.java.append(".length >= ");
                this.java.append(queueFound.getSize());
                this.java.append(" )");
                this.popType();
                break;
            }
            case DEQUEUE: {
                boolean registerAction = this.isSharedVariable(toVisit.getExp());
                this.caller.getDependencyManager().getShortName("obp.explorer.runtime.fiacre.FiacreQueueUtil");
                this.java.append("FiacreQueueUtil.dequeue(");
                if (registerAction) {
                    this.java.append("id, ");
                }
                toVisit.getExp().accept(this);
                if (registerAction) {
                    this.java.append(", actions");
                }
                this.java.append(")");
                break;
            }
            case UMINUS: {
                this.java.append("- (");
                toVisit.getExp().accept(this);
                this.java.append(")");
                break;
            }
            case UNOT: {
                this.java.append("!(");
                toVisit.getExp().accept(this);
                this.java.append(")");
                break;
            }
            case UDOLLAR: {
                toVisit.getExp().accept(this);
                break;
            }
        }
    }

    @Override
    public void visitBinExp(BinExp toVisit) {
        BinOp op = toVisit.getBinOp();
        if (op == BinOp.APPEND || op == BinOp.ENQUEUE) {
            this.caller.getDependencyManager().getShortName("obp.explorer.runtime.fiacre.FiacreQueueUtil");
            this.java.append("FiacreQueueUtil.");
            switch (op) {
                case APPEND: {
                    this.java.append("append");
                    break;
                }
                case ENQUEUE: {
                    this.java.append("enqueue");
                    break;
                }
            }
            boolean registerAction = this.isSharedVariable(toVisit.getLeft());
            this.java.append("(");
            if (registerAction) {
                this.java.append("id, ");
            }
            toVisit.getLeft().accept(this);
            this.java.append(",");
            this.pushType(this.peekType(CQueue.class).getInner());
            toVisit.getRight().accept(this);
            this.popType();
            if (registerAction) {
                this.java.append(", actions");
            }
            this.java.append(")");
        } else if (op == BinOp.BEQ || op == BinOp.BNE) {
            CType leftType = this.inferrer.infer(toVisit.getLeft()).resolve();
            CType inner = null;
            if (leftType instanceof CArray) {
                inner = ((CArray)leftType).getInner();
            } else if (leftType instanceof CQueue) {
                inner = ((CQueue)leftType).getInner();
            }
            this.pushType(leftType);
            if (inner != null) {
                this.caller.getDependencyManager().getShortName("java.util.Arrays");
                this.java.append("Arrays.");
                if (CTypeUtil.needDeepMethod(inner)) {
                    this.java.append("deepEquals");
                } else {
                    this.java.append("equals");
                }
                this.java.append("(");
                toVisit.getLeft().accept(this);
                this.java.append(",");
                toVisit.getRight().accept(this);
                this.java.append(")");
                if (op == BinOp.BNE) {
                    this.java.append(" == false");
                }
            } else if (CTypeUtil.isGeneratedClassType(leftType)) {
                toVisit.getLeft().accept(this);
                this.java.append(".equals(");
                toVisit.getRight().accept(this);
                this.java.append(")");
                if (op == BinOp.BNE) {
                    this.java.append(" == false");
                }
            } else {
                toVisit.getLeft().accept(this);
                if (op == BinOp.BEQ) {
                    this.java.append(" == ");
                } else {
                    this.java.append(" != ");
                }
                toVisit.getRight().accept(this);
            }
            this.popType();
        } else {
            this.java.append("(");
            toVisit.getLeft().accept(this);
            this.java.append(") ");
            switch (op) {
                case BADD: {
                    this.java.append("+");
                    break;
                }
                case BMINUS: {
                    this.java.append("-");
                    break;
                }
                case BMUL: {
                    this.java.append("*");
                    break;
                }
                case BDIV: {
                    this.java.append("/");
                    break;
                }
                case BMOD: {
                    this.java.append("%");
                    break;
                }
                case BAND: {
                    this.java.append("&&");
                    break;
                }
                case BOR: {
                    this.java.append("||");
                    break;
                }
                case BGE: {
                    this.java.append(">=");
                    break;
                }
                case BGT: {
                    this.java.append(">");
                    break;
                }
                case BLE: {
                    this.java.append("<=");
                    break;
                }
                case BLT: {
                    this.java.append("<");
                    break;
                }
            }
            this.java.append(" (");
            toVisit.getRight().accept(this);
            this.java.append(")");
        }
    }

    @Override
    public void visitFunctionRef(FunctionRef toVisit) {
        this.java.append(this.caller.getProgramName());
        this.java.append(".");
        this.java.append(NameUtil.uncapName(toVisit.getDecl().getName()));
        this.java.append("(");
        int length = this.java.length();
        int idx = 0;
        for (Exp param : toVisit.getParamList()) {
            if (this.java.length() > length) {
                this.java.append(", ");
            }
            this.pushType(new CExisting(toVisit.getDecl().getArg(idx++).getType()));
            param.accept(this);
            this.popType();
        }
        this.java.append(")");
    }

    @Override
    public void visitExternalFunctionRef(ExternalFunctionRef toVisit) {
        String contextClass = "((" + this.caller.getProgramName() + ")context.getProgram())";
        String paramClass = this.caller.getProgramName() + "." + NameUtil.capName(toVisit.getDecl().getName()) + "Params";
        String rTypeS = TypeUtil.toJavaDeclaration(toVisit.getDecl().getReturnType(), this.caller.getTypeNames());
        if (rTypeS.equals("boolean")) {
            rTypeS = "Boolean";
        } else if (rTypeS.equals("int")) {
            rTypeS = "Integer";
        }
        this.java.append("((new AbstractCallable<" + rTypeS + ">() {\n\t@Override\n\tpublic " + rTypeS + " call() {\n\t\t" + paramClass + " toto = " + contextClass + ".new " + NameUtil.capName(toVisit.getDecl().getName()) + "Params(");
        int length = this.java.length();
        int idx = 0;
        for (Exp param : toVisit.getParamList()) {
            if (this.java.length() > length) {
                this.java.append(", ");
            }
            this.pushType(new CExisting(toVisit.getDecl().getArg(idx++).getType()));
            param.accept(this);
            this.popType();
        }
        this.java.append(");\n");
        this.java.append("\t\t" + rTypeS + " result = " + this.caller.getProgramName() + "." + NameUtil.uncapName(toVisit.getDecl().getName()) + "(toto);\n");
        idx = 0;
        for (ExternalArgument eArg : toVisit.getDecl().getArgList()) {
            if (eArg.isWrite()) {
                this.pushType(new CExisting(toVisit.getDecl().getArg(idx).getType()));
                this.java.append("\t\t");
                toVisit.getParam(idx).accept(this);
                this.java.append("=toto.arg" + idx + ";\n");
                this.popType();
            }
            ++idx;
        }
        this.java.append("\t\treturn result;\n\t\t}\n}");
        this.java.append(").call())");
    }

    @Override
    public void visitBoolLiteral(BoolLiteral toVisit) {
        this.java.append(toVisit.isValue());
    }

    @Override
    public void visitNatLiteral(NatLiteral toVisit) {
        this.java.append(toVisit.getValue());
    }

    @Override
    public void visitCondExp(CondExp toVisit) {
        toVisit.getCond().accept(this);
        this.java.append(" ? ");
        this.pushType(CAny.anyType);
        toVisit.getIft().accept(this);
        this.java.append(" : ");
        toVisit.getIff().accept(this);
        this.popType();
    }

    @Override
    public void visitConstantRef(ConstantRef toVisit) {
        this.java.append(this.caller.getProgramName());
        this.java.append(".");
        this.java.append(NameUtil.capName(toVisit.getDecl().getName()));
    }

    @Override
    public void visitVarRef(VarRef toVisit) {
        if (toVisit.getDecl() instanceof LocalVariable) {
            LocalVariable local = (LocalVariable)toVisit.getDecl();
            if (this.caller.getVariableAnalyser().isConfigurationVariable(local) && this.generationMode == Mode.Behavior || this.generationMode == Mode.Composition) {
                this.java.append("me.");
            }
        }
        this.java.append(NameUtil.uncapName(toVisit.getDecl().getName()));
    }

    @Override
    public void visitConstrExp(ConstrExp toVisit) {
        CUnion cType = this.peekType(CUnion.class);
        TypeDecl decl = CTypeUtil.findType(cType, this.caller.getCTypeMap());
        this.java.append("new ");
        this.java.append(TypeUtil.toJavaDeclaration(decl.getIs(), this.getTypeNames()));
        this.java.append(".");
        this.java.append(NameUtil.capName(toVisit.getName()));
        this.java.append("(");
        if (toVisit.getArg() != null) {
            this.pushType(cType.getConstr(toVisit.getName()));
            toVisit.getArg().accept(this);
            this.popType();
        }
        this.java.append(")");
    }

    @Override
    public void visitInlineArray(InlineArray toVisit) {
        int i;
        CArray cArray = this.peekType(CArray.class);
        CType cInner = CTypeUtil.arrayOrQueueOf(cArray.getInner());
        String type = null;
        if (cInner.isAssignableFrom(CBool.boolType)) {
            type = "boolean";
        } else if (cInner.isAssignableFrom(CInt.intType)) {
            type = "int";
        } else {
            TypeDecl decl = CTypeUtil.findType(cInner, this.caller.getCTypeMap());
            type = TypeUtil.toJavaDeclaration(decl.getIs(), this.getTypeNames());
        }
        this.java.append("new ");
        this.java.append(type);
        int dimension = CTypeUtil.arrayOrQueueDimension(cArray.getInner());
        for (i = 0; i < dimension; ++i) {
            this.java.append("[]");
        }
        this.java.append(" {");
        this.pushType(cArray.getInner());
        for (i = 0; i < toVisit.getElemCount(); ++i) {
            Exp elem;
            if (i > 0) {
                this.java.append(", ");
            }
            if ((elem = toVisit.getElem(i)) instanceof InlineArray) {
                this.innerInlineArray((InlineArray)elem);
                continue;
            }
            if (elem instanceof InlineQueue) {
                this.innerInlineQueue((InlineArray)elem);
                continue;
            }
            elem.accept(this);
        }
        this.popType();
        this.java.append("}");
    }

    @Override
    public void visitInlineQueue(InlineQueue toVisit) {
        int i;
        CQueue cQueue = this.peekType(CQueue.class);
        CType cInner = CTypeUtil.arrayOrQueueOf(cQueue.getInner());
        String type = null;
        if (cInner.isAssignableFrom(CBool.boolType)) {
            type = "boolean";
        } else if (cInner.isAssignableFrom(CInt.intType)) {
            type = "int";
        } else {
            TypeDecl decl = CTypeUtil.findType(cInner, this.caller.getCTypeMap());
            type = TypeUtil.toJavaDeclaration(decl.getIs(), this.getTypeNames());
        }
        this.java.append("new ");
        this.java.append(type);
        int dimension = CTypeUtil.arrayOrQueueDimension(cQueue.getInner());
        for (i = 0; i < dimension; ++i) {
            this.java.append("[]");
        }
        this.java.append(" {");
        this.pushType(cQueue.getInner());
        for (i = 0; i < toVisit.getElemCount(); ++i) {
            Exp elem;
            if (i > 0) {
                this.java.append(", ");
            }
            if ((elem = toVisit.getElem(i)) instanceof InlineArray) {
                this.innerInlineArray((InlineArray)elem);
                continue;
            }
            if (elem instanceof InlineQueue) {
                this.innerInlineQueue((InlineArray)elem);
                continue;
            }
            elem.accept(this);
        }
        this.popType();
        this.java.append("}");
    }

    private void innerInlineArray(InlineArray toVisit) {
        CArray cArray = this.peekType(CArray.class);
        this.java.append("{");
        this.pushType(cArray.getInner());
        for (int i = 0; i < toVisit.getElemCount(); ++i) {
            Exp elem;
            if (i > 0) {
                this.java.append(", ");
            }
            if ((elem = toVisit.getElem(i)) instanceof InlineArray) {
                this.innerInlineArray((InlineArray)elem);
                continue;
            }
            if (elem instanceof InlineQueue) {
                this.innerInlineQueue((InlineArray)elem);
                continue;
            }
            elem.accept(this);
        }
        this.popType();
        this.java.append("}");
    }

    private void innerInlineQueue(InlineArray toVisit) {
        CQueue cQueue = this.peekType(CQueue.class);
        this.java.append("{");
        this.pushType(cQueue.getInner());
        for (int i = 0; i < toVisit.getElemCount(); ++i) {
            Exp elem;
            if (i > 0) {
                this.java.append(", ");
            }
            if ((elem = toVisit.getElem(i)) instanceof InlineArray) {
                this.innerInlineArray((InlineArray)elem);
                continue;
            }
            if (elem instanceof InlineQueue) {
                this.innerInlineQueue((InlineArray)elem);
                continue;
            }
            elem.accept(this);
        }
        this.popType();
        this.java.append("}");
    }

    @Override
    public void visitInlineRecord(InlineRecord toVisit) {
        CRecord cType = this.peekType(CRecord.class);
        TypeDecl decl = CTypeUtil.findType(cType, this.caller.getCTypeMap());
        String type = this.caller.getTypeNames().get(decl.getIs());
        this.java.append("new ");
        this.java.append(type);
        this.java.append("(");
        boolean first = true;
        for (String field : cType.getFieldList()) {
            if (!first) {
                this.java.append(",");
            }
            this.pushType(cType.getField(field));
            boolean found = false;
            for (ValuedField valued : toVisit.getValueList()) {
                if (!valued.getField().equals(field)) continue;
                valued.getValue().accept(this);
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Inline record doesn't set value for all fields.");
            }
            this.popType();
            first = false;
        }
        this.java.append(")");
    }

    @Override
    public void visitArrayElem(ArrayElem toVisit) {
        toVisit.getArray().accept(this);
        this.java.append("[");
        toVisit.getIndex().accept(this);
        this.java.append("]");
    }

    @Override
    public void visitRecordElem(RecordElem toVisit) {
        toVisit.getRecord().accept(this);
        this.java.append(".");
        this.java.append(NameUtil.uncapName(toVisit.getField()));
    }

    @Override
    public void visitPatternExp(PatternExp toVisit) {
        StringBuilder oldJava = this.java;
        this.java = new StringBuilder();
        CType cType = this.inferrer.infer(toVisit.getExp());
        this.pushType(cType);
        toVisit.getExp().accept(this);
        this.popType();
        String expression = this.java.toString();
        String condition = this.caller.getPatternGenerator().generateCondition(cType, expression, toVisit.getPattern());
        this.java = oldJava;
        this.java.append(condition);
    }

    private void pushType(CType type) {
        this.typeStack.push(type);
    }

    private CType popType() {
        return this.popType(CType.class);
    }

    private <T extends CType> T popType(Class<T> kind) {
        CType type = this.typeStack.pop().resolve();
        if (!kind.isInstance(type)) {
            throw new IllegalArgumentException("Type '" + type + "' isn't a '" + kind.getSimpleName() + "'.");
        }
        return (T)((CType)kind.cast(type));
    }

    private CType peekType() {
        return this.peekType(CType.class);
    }

    private <T extends CType> T peekType(Class<T> kind) {
        CType type = this.typeStack.peek().resolve();
        if (!kind.isInstance(type)) {
            throw new IllegalArgumentException("Type '" + type + "' isn't a '" + kind.getSimpleName() + "'.");
        }
        return (T)((CType)kind.cast(type));
    }

    public static enum Mode {
        Composition,
        Behavior,
        Function;

    }
}

