/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker.type;

import obp.fiacre.checker.type.CAny;
import obp.fiacre.checker.type.CType;

public class CQueue
extends CType {
    public static final CQueue empty = new CQueue(null);
    private final CType inner;
    private final int size;

    public CQueue(CType inner, int size) {
        this.inner = inner;
        this.size = size;
    }

    public CQueue(CType type) {
        this(type, -1);
    }

    public CType getInner() {
        return this.inner;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isAssignableFrom(CType type) {
        if (type == null) {
            return false;
        }
        if (this == (type = type.resolve())) {
            return true;
        }
        if (type == CAny.anyType) {
            return true;
        }
        if (!(type instanceof CQueue)) {
            return false;
        }
        CQueue other = (CQueue)type;
        if (this == empty || other == empty) {
            return true;
        }
        if (this.size >= 0 && other.size >= 0 && other.size != this.size) {
            return false;
        }
        return this.inner.isAssignableFrom(other.inner);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CQueue) {
            CQueue other = (CQueue)obj;
            return this.inner.equals(other.inner) && this.size == other.size;
        }
        return false;
    }

    public String toString() {
        return "queue " + this.size + " of " + this.inner;
    }
}

