/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd;

import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.runtime.AEFDRuntime;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import fr.ensta.aefd.toolbox.AEFDToolbox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import plug.core.ILanguageLoader;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.explorer.BFSExplorer;
import plug.folding.runtime.FoldingRuntime;
import plug.statespace.SimpleStateSpaceManager;

public class AEFDLoader
implements ILanguageLoader<FoldingRuntime> {
    String initializeSequenceFile = null;
    String initializeConfigurationFile = null;
    String environmentAlternativesFile = null;
    boolean executionOrder = true;
    boolean folding = true;

    List<String> readEventListFromFile(String filename) {
        if (filename != null) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                return br.lines().collect(Collectors.toList());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    public FoldingRuntime<AEFDRuntimeSystemState, AEFDTransition> getRuntime(URI uri, Map<String, Object> map) {
        this.initializeSequenceFile = null;
        this.initializeConfigurationFile = null;
        this.environmentAlternativesFile = null;
        this.executionOrder = true;
        this.folding = true;
        AEFDToolbox toolbox = new AEFDToolbox();
        File aefdFile = null;
        try {
            aefdFile = new File(uri);
            String parent = aefdFile.getParent();
            BufferedReader br = new BufferedReader(new FileReader(aefdFile));
            br.lines().map(line -> parent + "/" + line.trim()).forEach(file -> {
                if (file.endsWith(".init.sequence")) {
                    this.initializeSequenceFile = file;
                } else if (file.endsWith(".init.configuration")) {
                    this.initializeConfigurationFile = file;
                } else if (file.endsWith(".env.alternative")) {
                    this.environmentAlternativesFile = file;
                } else if (file.endsWith("noExecutionOrder")) {
                    this.executionOrder = false;
                } else if (file.endsWith("noFolding")) {
                    this.folding = false;
                } else {
                    toolbox.parser.addFile(file);
                }
            });
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            toolbox.parser.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> initializationSequence = this.readEventListFromFile(this.initializeSequenceFile);
        List<String> environmentAlternatives = this.readEventListFromFile(this.environmentAlternativesFile);
        ArrayList<String> rest = new ArrayList<String>(environmentAlternatives);
        rest.addAll(initializationSequence);
        System.out.println("before finalize automates  " + toolbox.model.getAllAutomates().size() + "  variables " + toolbox.model.getAllVariables().size() + " func entity " + toolbox.model.getAllFunctionalEntity().size());
        if (toolbox.finalizeModel(rest)) {
            System.out.println("before trim automates  " + toolbox.model.getAllAutomates().size() + "  variables " + toolbox.model.getAllVariables().size() + " func entity " + toolbox.model.getAllFunctionalEntity().size());
            toolbox.trimModel();
            if (initializationSequence.isEmpty()) {
                toolbox.moveEventToInitPhase("Init");
            } else {
                toolbox.moveEventToInitPhase(initializationSequence);
            }
            if (this.executionOrder) {
                toolbox.model.addDeclarationBasedExecutionOrder();
            }
            toolbox.generateFiacre();
        }
        try {
            System.err.println("The results are generated in: " + new File(".").getAbsolutePath());
            toolbox.handles.exportAsRepository("out/", aefdFile.getName() + ".results");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AEFDRuntime runtime = new AEFDRuntime();
        runtime.loadModel(toolbox.model);
        List<String> initializationConfiguration = this.readEventListFromFile(this.initializeConfigurationFile);
        runtime.provideInitialVariableValues(initializationConfiguration);
        return new FoldingRuntime((ITransitionRelation)runtime, this.folding ? c -> !c.isStableState() : c -> false, transitionRelation -> new BFSExplorer(transitionRelation, (IStateSpaceManager)new SimpleStateSpaceManager(false)));
    }
}

