/*
 * Decompiled with CFR 0.152.
 */
package plug.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectGraphExploration {
    Map<Object, Class<?>> closed = new IdentityHashMap();
    ArrayDeque<StackEntry> open = new ArrayDeque();
    IVisitor visitor;
    boolean excludeTransient = true;
    boolean excludeStatic = true;
    private final Set<Class<?>> excludedClasses = Collections.newSetFromMap(new IdentityHashMap());
    Map<Class<?>, List<Field>> fieldCache = new IdentityHashMap();

    public ObjectGraphExploration(IVisitor visitor) {
        this.visitor = visitor;
    }

    public ObjectGraphExploration visitor(IVisitor visitor) {
        this.visitor = visitor;
        return this;
    }

    public ObjectGraphExploration includeTransient() {
        this.excludeTransient = false;
        return this;
    }

    public ObjectGraphExploration excludeTransient() {
        this.excludeTransient = true;
        return this;
    }

    public ObjectGraphExploration includeStatic() {
        this.excludeStatic = false;
        return this;
    }

    public ObjectGraphExploration excludeStatic() {
        this.excludeStatic = true;
        return this;
    }

    public ObjectGraphExploration excludeClasses(Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (c == null) {
                throw new NullPointerException("Null class not allowed");
            }
            this.excludedClasses.add(c);
        }
        return this;
    }

    private boolean isExcludedClass(Class<?> clazz) {
        return this.excludedClasses.stream().anyMatch(c -> c.isAssignableFrom(clazz));
    }

    public void explore(Object root, Class<?> clazz) {
        this.closed.clear();
        this.open.clear();
        this.closed.put(root, clazz);
        this.open.push(new StackEntry(root));
        this.run();
    }

    boolean addIfNotClosed(Object o, Class<?> clazz) {
        if (o instanceof StackEntry) {
            StackEntry se = (StackEntry)o;
            Class<?> notInYet = this.closed.put(se.field, clazz);
            if (notInYet == null) {
                this.open.push(se);
            }
            return notInYet == null;
        }
        Class<?> notInYet = this.closed.put(o, clazz);
        if (notInYet == null) {
            this.open.push(new StackEntry(o));
        }
        return notInYet == null;
    }

    void run() {
        boolean isDone = false;
        boolean stepIn = true;
        while (!isDone && !this.open.isEmpty()) {
            StackEntry entry = this.open.peek();
            final Object current = entry.object;
            Class<?> clazz = this.closed.get(current);
            Field field = entry.field;
            if (field != null) {
                if (entry.fieldDone) {
                    this.open.pop();
                    isDone = this.visitor.endField(field, current, clazz);
                    continue;
                }
                entry.fieldDone = true;
                Class<?> fieldType = field.getType();
                try {
                    Object value;
                    field.setAccessible(true);
                    stepIn = this.visitor.startField(field, current, fieldType);
                    if (!stepIn || (value = field.get(current)) != null && this.isExcludedClass(value.getClass())) continue;
                    this.addIfNotClosed(value, fieldType);
                }
                catch (IllegalAccessException value) {}
                continue;
            }
            Iterator<Object> postIterator = entry.post;
            if (postIterator == null) {
                if (clazz.isPrimitive()) {
                    stepIn = this.visitor.startPrimitive(current, clazz);
                    postIterator = Collections.emptyIterator();
                    entry.setPost(postIterator);
                } else if (clazz.isArray()) {
                    stepIn = this.visitor.startArray(current, clazz);
                    if (!stepIn) {
                        postIterator = Collections.emptyIterator();
                        entry.setPost(postIterator);
                    } else {
                        Iterator iterator;
                        postIterator = iterator = new Iterator(){
                            final int size;
                            int i;
                            {
                                this.size = Array.getLength(current);
                                this.i = 0;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.i < this.size;
                            }

                            public Object next() {
                                return Array.get(current, this.i++);
                            }
                        };
                        entry.setPost(postIterator);
                    }
                } else {
                    stepIn = this.visitor.startObject(current, clazz);
                    if (!stepIn) {
                        postIterator = Collections.emptyIterator();
                        entry.setPost(postIterator);
                    } else {
                        List<Field> fields = this.getAllFields(current.getClass());
                        postIterator = fields.iterator();
                        entry.setPost(postIterator);
                    }
                }
            }
            if (postIterator.hasNext()) {
                Object target = postIterator.next();
                if (target instanceof Field) {
                    field = (Field)target;
                    int modifiers = field.getModifiers();
                    if (this.excludeStatic && (modifiers & 8) == 8 || this.excludeTransient && (modifiers & 0x80) == 128) continue;
                    Class<?> fieldType = field.getType();
                    this.addIfNotClosed(new StackEntry(field, current), fieldType);
                    continue;
                }
                Class<?> arrayType = clazz.getComponentType();
                this.addIfNotClosed(target, arrayType);
                continue;
            }
            this.open.pop();
            if (clazz.isPrimitive()) {
                isDone = this.visitor.endPrimitive(current, clazz);
                continue;
            }
            if (clazz.isArray()) {
                isDone = this.visitor.endArray(current, clazz);
                continue;
            }
            isDone = this.visitor.endObject(current, clazz);
        }
    }

    private List<Field> getAllFields(Class<?> clazz) {
        List<Field> fields = this.fieldCache.get(clazz);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            fields.addAll(this.getAllFields(clazz.getSuperclass()));
        }
        return fields;
    }

    class StackEntry {
        Object object;
        Field field;
        boolean fieldDone = false;
        Iterator<Object> post;

        StackEntry(Object object) {
            this(null, object);
        }

        StackEntry(Field field, Object object) {
            this.field = field;
            this.object = object;
        }

        public void setPost(Iterator<Object> post) {
            this.post = post;
        }
    }

    public static interface IVisitor {
        public boolean startObject(Object var1, Class<?> var2);

        public boolean endObject(Object var1, Class<?> var2);

        public boolean startPrimitive(Object var1, Class<?> var2);

        public boolean endPrimitive(Object var1, Class<?> var2);

        public boolean startArray(Object var1, Class<?> var2);

        public boolean endArray(Object var1, Class<?> var2);

        public boolean startField(Field var1, Object var2, Class<?> var3);

        public boolean endField(Field var1, Object var2, Class<?> var3);
    }
}

