/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.meta.ModelReferences;
import fr.ensta.aefd.runtime.AEFDRuntimeInfos;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import java.util.HashSet;
import java.util.Set;

public class AEFDRuntimeInitialStateProvider {
    private final AEFDRuntimeInfos infos;
    private Set<AEFDRuntimeSystemState> initialStates;
    private AEFDFunctionalEntity[] variableInitialValues;

    public AEFDRuntimeInitialStateProvider(AEFDRuntimeInfos infos) {
        this.infos = infos;
        this.variableInitialValues = new AEFDFunctionalEntity[0];
    }

    public void setVariableInitialValues(ModelReferences references, String[] variableInitialStrings) {
        this.variableInitialValues = new AEFDFunctionalEntity[variableInitialStrings.length];
        for (int i = 0; i < variableInitialStrings.length; ++i) {
            this.variableInitialValues[i] = references.getFunctionalEntity(variableInitialStrings[i], false);
            if (this.variableInitialValues[i] != null) continue;
            this.variableInitialValues[i] = references.getFunctionalEntity(variableInitialStrings[i], true);
            System.err.println("Warning: created a new functional entity from adding initial value '" + variableInitialStrings[i] + "'");
        }
    }

    private void compute() {
        AEFDRuntimeSystemState initialState = new AEFDRuntimeSystemState(this.infos);
        for (int automateIndex = 0; automateIndex < this.infos.getNumberOfAutomates(); ++automateIndex) {
            initialState.getAutomatesStates()[automateIndex] = this.getInitialPlaceIndex(automateIndex);
        }
        for (int variableIndex = 0; variableIndex < this.infos.getNumberOfVariables(); ++variableIndex) {
            initialState.getVariables()[variableIndex] = this.getInitialValue(variableIndex);
        }
        this.initialStates.add(initialState);
    }

    private int getInitialPlaceIndex(int automateIndex) {
        AEFDAutomate automate = this.infos.getAutomateFromIndex(automateIndex);
        String initialPlace = automate.getInitialPlace();
        return this.infos.getAutomateStateIndex(automate, initialPlace);
    }

    private boolean getInitialValue(int variableIndex) {
        AEFDBooleanVariable variable = this.infos.getVariableFromIndex(variableIndex);
        boolean[] possibleValues = new boolean[]{true, true};
        this.checkForProvidedValue(variableIndex, possibleValues);
        if (possibleValues[0] && possibleValues[1]) {
            System.err.println("Warning: variable " + variable.getName() + " can be both " + variable.getStringValue(false) + " (false) and " + variable.getStringValue(true) + " (true).");
        } else if (!possibleValues[0] && !possibleValues[1]) {
            throw new IllegalStateException("Variable: " + variable.getName() + " does not have a legal initial value.");
        }
        return !possibleValues[0];
    }

    private void checkForProvidedValue(int variableIndex, boolean[] possibleValues) {
        AEFDBooleanVariable variable = this.infos.getVariableFromIndex(variableIndex);
        for (AEFDFunctionalEntity functionalEntity : this.variableInitialValues) {
            if (functionalEntity == null || !functionalEntity.getIdentifier().contains(variable.getName())) continue;
            if (functionalEntity.getSuffix().equals(variable.getStringValue(true))) {
                possibleValues[0] = false;
                continue;
            }
            possibleValues[1] = false;
        }
    }

    public Set<AEFDRuntimeSystemState> getInitialStates() {
        this.initialStates = new HashSet<AEFDRuntimeSystemState>();
        this.compute();
        return this.initialStates;
    }
}

