/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.fiacre;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Stack;
import obp.explorer.runtime.Program;
import obp.explorer.runtime.util.NameUtil;
import obp.literal.AnyLiteral;
import obp.literal.ArrayLiteral;
import obp.literal.BooleanLiteral;
import obp.literal.ConstantReference;
import obp.literal.IntegerLiteral;
import obp.literal.Literal;
import obp.literal.LiteralField;
import obp.literal.LiteralVisitor;
import obp.literal.RecordLiteral;
import obp.literal.StringLiteral;
import obp.literal.UnionLiteral;
import org.xid.basics.error.DiagnosticUtil;

public class LiteralToJavaObject
implements LiteralVisitor {
    private final Program program;
    private final Stack<Object> objectStack = new Stack();

    public static Object toJava(Literal literal, Program program) {
        LiteralToJavaObject transformer = new LiteralToJavaObject(program);
        literal.accept(transformer);
        return transformer.objectStack.pop();
    }

    private LiteralToJavaObject(Program program) {
        this.program = program;
    }

    @Override
    public void visitAnyLiteral(AnyLiteral toVisit) {
        throw new IllegalArgumentException("Can't create an 'any' literal.");
    }

    @Override
    public void visitStringLiteral(StringLiteral toVisit) {
        this.objectStack.push(toVisit.getValue());
    }

    @Override
    public void visitBooleanLiteral(BooleanLiteral toVisit) {
        this.objectStack.push(toVisit.isValue());
    }

    @Override
    public void visitIntegerLiteral(IntegerLiteral toVisit) {
        this.objectStack.push(toVisit.getValue());
    }

    @Override
    public void visitConstantReference(ConstantReference toVisit) {
        try {
            Class<?> programClass = this.program.getClass();
            Field field = programClass.getField(NameUtil.capName(toVisit.getName()));
            this.objectStack.push(field.get(null));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Constant '" + toVisit.getName() + "' doesn't exist.");
        }
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral toVisit) {
        try {
            Object value = null;
            if ("integer".equals(toVisit.getTypeName())) {
                value = Array.newInstance(Integer.TYPE, toVisit.getValueCount());
            } else if ("boolean".equals(toVisit.getTypeName())) {
                value = Array.newInstance(Boolean.TYPE, toVisit.getValueCount());
            } else if ("string".equals(toVisit.getTypeName())) {
                value = Array.newInstance(String.class, toVisit.getValueCount());
            } else {
                Class<?> programClass = this.program.getClass();
                String packageName = programClass.getPackage().getName();
                String className = packageName + "." + NameUtil.capName(toVisit.getTypeName());
                Class<?> innerType = programClass.getClassLoader().loadClass(className);
                value = Array.newInstance(innerType, toVisit.getValueCount());
            }
            for (int i = 0; i < toVisit.getValueCount(); ++i) {
                toVisit.getValue(i).accept(this);
                Array.set(value, i, this.objectStack.pop());
            }
            this.objectStack.push(value);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Type '" + toVisit.getTypeName() + "' doesn't exist.");
        }
    }

    @Override
    public void visitLiteralField(LiteralField toVisit) {
    }

    @Override
    public void visitRecordLiteral(RecordLiteral toVisit) {
        try {
            Class<?> programClass = this.program.getClass();
            String packageName = programClass.getPackage().getName();
            String className = packageName + "." + NameUtil.capName(toVisit.getTypeName());
            Class<?> type = programClass.getClassLoader().loadClass(className);
            Object value = type.newInstance();
            for (LiteralField field : toVisit.getFieldList()) {
                field.getValue().accept(this);
                Object fieldValue = this.objectStack.pop();
                try {
                    String fieldName = NameUtil.uncapName(field.getName());
                    Field javaField = type.getField(fieldName);
                    javaField.set(value, fieldValue);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Field '" + field.getName() + "' doesn't exist in type '" + toVisit.getTypeName() + "'.");
                }
            }
            this.objectStack.push(value);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Type '" + toVisit.getTypeName() + "' doesn't exist.");
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Internal error (" + DiagnosticUtil.createMessage((Throwable)e) + ").");
        }
    }

    @Override
    public void visitUnionLiteral(UnionLiteral toVisit) {
        try {
            Object value;
            Class<?> programClass = this.program.getClass();
            String packageName = programClass.getPackage().getName();
            String className = packageName + "." + NameUtil.capName(toVisit.getTypeName());
            Class<?> unionType = programClass.getClassLoader().loadClass(className);
            Class<?> type = null;
            String constrName = NameUtil.capName(toVisit.getName());
            for (Class<?> oneConstrType : unionType.getClasses()) {
                if (!oneConstrType.getSimpleName().equals(constrName)) continue;
                type = oneConstrType;
                break;
            }
            if (type == null) {
                throw new IllegalArgumentException("Constr '" + toVisit.getName() + "' doesn't exist in union '" + toVisit.getTypeName() + "'.");
            }
            if (toVisit.getValue() != null) {
                toVisit.getValue().accept(this);
                Object fieldValue = this.objectStack.pop();
                Constructor<?> constructor = this.findConstructor(type, fieldValue.getClass());
                if (constructor == null) {
                    throw new IllegalArgumentException("Constr '" + toVisit.getName() + "' doesn't accept '" + fieldValue.getClass().getSimpleName() + "' typed argument.");
                }
                value = constructor.newInstance(fieldValue);
            } else {
                value = type.newInstance();
            }
            this.objectStack.push(value);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Type '" + toVisit.getTypeName() + "' doesn't exist.");
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Internal error (" + DiagnosticUtil.createMessage((Throwable)e) + ").");
        }
    }

    private Constructor<?> findConstructor(Class<?> type, Class<?> parameterType) {
        for (Constructor<?> constructor : type.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1) continue;
            Class<?> testedType = parameterTypes[0];
            if (testedType.isPrimitive()) {
                if (testedType == Integer.TYPE && parameterType == Integer.class) {
                    return constructor;
                }
                if (testedType != Boolean.TYPE || parameterType != Boolean.class) continue;
                return constructor;
            }
            if (!testedType.isAssignableFrom(parameterType)) continue;
            return constructor;
        }
        return null;
    }
}

