/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.transform;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.handler.ModelHandles;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ReorderAutomates {
    private AEFDModel model;
    private ModelHandles handles;
    private LinkedList<AEFDAutomate> reordered = new LinkedList();

    public void load(AEFDModel model, ModelHandles handles) {
        this.model = model;
        this.handles = handles;
        this.reordered.clear();
    }

    public void moveUp(AEFDAutomate automate) {
        int oldIndex = this.model.getAllAutomates().indexOf(automate);
        this.reordered.remove(automate);
        int newIndex = this.reordered.size();
        this.reordered.addLast(automate);
        this.model.getAllAutomates().remove(automate);
        this.model.getAllAutomates().add(newIndex, automate);
        this.handles.log("Moved automate from index " + oldIndex + " to index " + newIndex);
    }

    public void reorder(List<AEFDAutomate> order) {
        for (AEFDAutomate automate : order) {
            this.moveUp(automate);
        }
        this.handles.logPrettyPrint();
    }

    public void reorder(Comparator<AEFDAutomate> comparator) {
        LinkedList<AEFDAutomate> order = new LinkedList<AEFDAutomate>();
        order.addAll(this.model.getAllAutomates());
        Collections.sort(order, comparator);
        this.reorder(order);
    }
}

