/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.meta.ModelReferences;
import fr.ensta.aefd.toolbox.tools.analysis.RawModelValidation;
import fr.ensta.aefd.toolbox.tools.handler.ModelHandles;
import fr.ensta.aefd.toolbox.tools.parser.Parser;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.AEFD2Fiacre;
import fr.ensta.aefd.toolbox.tools.transform.EnvGenerator;
import fr.ensta.aefd.toolbox.tools.transform.FlatMultipleTokens;
import fr.ensta.aefd.toolbox.tools.transform.MoveEventToInit;
import fr.ensta.aefd.toolbox.tools.transform.RemoveUnused;
import fr.ensta.aefd.toolbox.tools.transform.RemoveUselessAutomates;
import fr.ensta.aefd.toolbox.tools.transform.ReorderAutomates;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import obp.fiacre.model.Program;
import obp.fiacre.util.FiacrePrinter;

public class AEFDToolbox {
    public final AEFDModel model = new AEFDModel();
    public final ModelHandles handles = new ModelHandles(this.model);
    public final ModelReferences references = new ModelReferences(this.model);
    public final Parser parser;
    public final MoveEventToInit init;
    public final ReorderAutomates reorder;
    public final AEFD2Fiacre fiacre;

    public AEFDToolbox() {
        this.references.synchronizeUsed();
        this.parser = new Parser(this.model, this.handles, this.references);
        this.init = new MoveEventToInit();
        this.reorder = new ReorderAutomates();
        this.fiacre = new AEFD2Fiacre();
    }

    public boolean rawModelIsValid() {
        RawModelValidation validation = new RawModelValidation();
        validation.analyse(this.model);
        this.handles.log(validation.getShortReport());
        return validation.isValid();
    }

    public void flatMultipleTokens() {
        FlatMultipleTokens flatten = new FlatMultipleTokens();
        flatten.transform(this.model, this.handles);
    }

    public void addEnvironment() {
        EnvGenerator envGenerator = new EnvGenerator();
        envGenerator.addEnvToModel(this.model, this.handles, this.references);
    }

    public void addEnvironment(Collection<String> environmentRestrictions) {
        EnvGenerator envGenerator = new EnvGenerator();
        Collection restrictions = environmentRestrictions.stream().map(e -> this.references.getFunctionalEntity((String)e)).filter(e -> e != null).collect(Collectors.toList());
        envGenerator.setEnvironmentRestictions(restrictions);
        envGenerator.addEnvToModel(this.model, this.handles, this.references);
    }

    public boolean removeUnused() {
        RemoveUnused remove = new RemoveUnused();
        remove.transform(this.model, this.handles);
        return remove.getTotalRemovedActionCount() > 0;
    }

    public boolean removeUselessAutomates() {
        RemoveUselessAutomates remove = new RemoveUselessAutomates();
        remove.transform(this.model, this.handles);
        return remove.getRemovedCount() > 0;
    }

    public boolean finalizeModel(Collection<String> environmentRestrictions) {
        if (this.rawModelIsValid()) {
            this.flatMultipleTokens();
            this.addEnvironment(environmentRestrictions);
            return true;
        }
        return false;
    }

    public boolean finalizeModel() {
        if (this.rawModelIsValid()) {
            this.flatMultipleTokens();
            this.addEnvironment();
            return true;
        }
        return false;
    }

    public void trimModel() {
        this.removeUnused();
        while (this.removeUselessAutomates() || this.removeUnused()) {
        }
        this.references.synchronizeUsed();
    }

    public void moveEventToInitPhase(String partialEventName) {
        LinkedList<AEFDFunctionalEntity> initPhase = new LinkedList<AEFDFunctionalEntity>();
        for (AEFDFunctionalEntity event : this.model.getAllFunctionalEntity()) {
            if (!event.getIdentifier().contains(partialEventName)) continue;
            initPhase.addLast(event);
        }
        this.init.load(this.model, this.references, this.handles);
        this.init.moveUp(initPhase);
    }

    public void moveEventToInitPhase(List<String> eventNames) {
        List<AEFDFunctionalEntity> list = eventNames.stream().map(e -> this.references.getFunctionalEntity((String)e)).filter(e -> e != null).collect(Collectors.toList());
        this.init.load(this.model, this.references, this.handles);
        this.init.moveUp(list);
    }

    public void reorderAutomates(Comparator<AEFDAutomate> comparator) {
        this.reorder.load(this.model, this.handles);
        this.reorder.reorder(comparator);
    }

    public void generateFiacre() {
        FiacrePrinter fiacrePrinter = new FiacrePrinter();
        Program fiacreProgram = this.fiacre.generateProgram(this.model);
        String fiacreString = fiacrePrinter.print(fiacreProgram);
        this.handles.logItem("Fiacre", fiacreString, "fcr");
    }

    public static void main(String[] args) throws Exception {
        String caseName = args[0];
        AEFDToolbox toolbox = new AEFDToolbox();
        for (int i = 1; i < args.length; ++i) {
            toolbox.parser.addFile(args[i]);
        }
        toolbox.parser.parse();
        if (toolbox.finalizeModel()) {
            toolbox.trimModel();
        }
        toolbox.moveEventToInitPhase("Init");
        toolbox.generateFiacre();
        toolbox.handles.printLogs();
        toolbox.handles.exportAsRepository("out/", caseName);
    }
}

