/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.model;

import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;

public interface AEFDBooleanExpression {
    public static final AEFDBooleanExpression TRUE = new Constant(){

        @Override
        public boolean getValue() {
            return true;
        }
    };
    public static final AEFDBooleanExpression FALSE = new Constant(){

        @Override
        public boolean getValue() {
            return false;
        }
    };

    public void accept(Visitor var1);

    public static class And
    extends Operator {
        public And(AEFDBooleanExpression lhs, AEFDBooleanExpression rhs) {
            super(lhs, rhs);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitAnd(this);
        }
    }

    public static class Or
    extends Operator {
        public Or(AEFDBooleanExpression lhs, AEFDBooleanExpression rhs) {
            super(lhs, rhs);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitOr(this);
        }
    }

    public static abstract class Operator
    implements AEFDBooleanExpression {
        private final AEFDBooleanExpression lhs;
        private final AEFDBooleanExpression rhs;

        public Operator(AEFDBooleanExpression lhs, AEFDBooleanExpression rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public AEFDBooleanExpression getLhs() {
            return this.lhs;
        }

        public AEFDBooleanExpression getRhs() {
            return this.rhs;
        }
    }

    public static class Not
    implements AEFDBooleanExpression {
        private final AEFDBooleanExpression expression;

        public Not(AEFDBooleanExpression expression) {
            this.expression = expression;
        }

        public AEFDBooleanExpression getExpression() {
            return this.expression;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNot(this);
        }
    }

    public static class VariableEvaluation
    implements AEFDBooleanExpression {
        private final AEFDBooleanVariable booleanVariable;
        private final boolean expectedValue;

        public VariableEvaluation(AEFDBooleanVariable booleanVariable, boolean expectedValue) {
            this.booleanVariable = booleanVariable;
            this.expectedValue = expectedValue;
        }

        public AEFDBooleanVariable getBooleanVariable() {
            return this.booleanVariable;
        }

        public boolean getExpectedValue() {
            return this.expectedValue;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitVariableEvaluation(this);
        }
    }

    public static class Trigger
    implements AEFDBooleanExpression {
        private final AEFDFunctionalEntity functionalEntity;

        public Trigger(AEFDFunctionalEntity functionalEntity) {
            this.functionalEntity = functionalEntity;
        }

        public AEFDFunctionalEntity getFunctionalEntity() {
            return this.functionalEntity;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTrigger(this);
        }
    }

    public static abstract class Constant
    implements AEFDBooleanExpression {
        public abstract boolean getValue();

        @Override
        public void accept(Visitor visitor) {
            visitor.visitConstant(this);
        }
    }

    public static interface Visitor {
        public void visitConstant(Constant var1);

        public void visitTrigger(Trigger var1);

        public void visitVariableEvaluation(VariableEvaluation var1);

        public void visitNot(Not var1);

        public void visitOr(Or var1);

        public void visitAnd(And var1);
    }
}

