/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.sequence;

import java.util.List;
import obp.ui.sequence.LifeLine;
import obp.ui.sequence.SequenceDiagram;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.Displayable;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;
import org.xid.basics.ui.diagram.interaction.Handle;
import org.xid.basics.ui.diagram.interaction.InteractionObject;

public class LifeLineElement
extends Element.Stub {
    public static final RGB backgroundRgb = new RGB(140, 210, 250);
    private float[] centerPoint;
    private float width;
    private float height;
    private LifeLine line;
    private float[] headerRectangle;

    public LifeLineElement(LifeLine line, float[] point, float width, float height) {
        this.line = line;
        this.centerPoint = point;
        this.width = width;
        this.height = height;
        this.updateHeaderRectangle();
    }

    public LifeLine getModel() {
        return this.line;
    }

    public float getX() {
        return this.centerPoint[0];
    }

    public float[] getPoint() {
        return this.centerPoint;
    }

    public void computeBounds(float[] result, DiagramContext context) {
        Geometry.copyPoints((float[])this.headerRectangle, (float[])result);
        result[3] = result[3] + this.height;
        Geometry.expandRectangle((float[])result, (float)5.0f, (float)5.0f);
    }

    private void updateHeaderRectangle() {
        if (this.headerRectangle == null) {
            this.headerRectangle = new float[4];
        }
        this.headerRectangle[0] = this.centerPoint[0] - this.width / 2.0f;
        this.headerRectangle[1] = this.centerPoint[1] - 20.0f;
        this.headerRectangle[2] = this.centerPoint[0] + this.width / 2.0f;
        this.headerRectangle[3] = this.centerPoint[1] + 20.0f;
    }

    public void display(GC gc, DiagramContext context) {
        float[] headerRectangle = new float[]{this.centerPoint[0] - this.width / 2.0f, this.centerPoint[1] - 20.0f, this.centerPoint[0] + this.width / 2.0f, this.centerPoint[1] + 20.0f};
        float[] shadowRetangle = Geometry.copyPoints((float[])headerRectangle);
        gc.setForeground(context.getResources().getSystemColor(15));
        gc.setBackground(context.getResources().getSystemColor(15));
        Geometry.translatePointsBy((float[])shadowRetangle, (float)3.0f, (float)3.0f);
        GcUtils.drawRoundRectangle((GC)gc, (float[])shadowRetangle, (float)20.0f, (float)20.0f, (boolean)true);
        gc.setForeground(context.getResources().getSystemColor(2));
        if (this.getModel().isVisible()) {
            gc.setBackground(context.getResources().getColor(backgroundRgb));
        } else {
            gc.setBackground(context.getResources().getSystemColor(15));
        }
        GcUtils.drawRoundRectangle((GC)gc, (float[])headerRectangle, (float)20.0f, (float)20.0f, (boolean)true);
        gc.setClipping(GcUtils.toSWTRectangle((float[])headerRectangle));
        GcUtils.drawStringAligned((GC)gc, (String)this.line.getLabel(), (float)this.centerPoint[0], (float)this.centerPoint[1], (int)-1);
        gc.setClipping((Rectangle)null);
        GcUtils.drawLine((GC)gc, (float)this.centerPoint[0], (float)(this.centerPoint[1] + 20.0f), (float)this.centerPoint[0], (float)(this.centerPoint[1] + 20.0f + this.height));
    }

    public void hitTesting(List<Element> result, float[] detectionPoint, float[] detectionRectangle, int type, DiagramContext context) {
        if (detectionRectangle != null) {
            if (Geometry.rectangleIntersectsRectangle((float[])this.headerRectangle, (float[])detectionRectangle)) {
                result.add((Element)this);
            }
        } else if (Geometry.rectangleContainsPoint((float[])this.headerRectangle, (float[])detectionPoint)) {
            result.add((Element)this);
        }
    }

    public void computeInteractionObjects(List<InteractionObject> result, int type, DiagramContext context) {
        if (type == 0) {
            Handle.addRectangleHandles(result, (Element)this, (float[])this.headerRectangle, (boolean)true, (boolean)false);
        }
    }

    public boolean click(InteractionObject interaction, float[] point, int count, DiagramContext context) {
        if (count >= 2) {
            this.line.setVisible(!this.line.isVisible());
            return true;
        }
        return false;
    }

    public boolean move(float[] point, InteractionObject interaction, int step, DiagramContext context) {
        float x;
        context.invalidate((Displayable)this);
        Geometry.translatePointsBy((float[])this.centerPoint, (float)(point[0] - this.centerPoint[0]), (float)0.0f);
        this.updateHeaderRectangle();
        context.invalidate((Displayable)this);
        ((SequenceDiagram)context.getDiagram()).updateAll(context);
        boolean move = false;
        if (step == -1 && (x = this.getX()) != this.getModel().getX()) {
            this.getModel().setX(x);
            move = true;
        }
        return move;
    }

    public boolean toolTipRequest(float[] point, DiagramContext context) {
        String message = this.getModel().isVisible() ? "Double click to hide line." : "Double click to show line.";
        context.showBalloon(null, message);
        return true;
    }
}

