/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis.graph;

import fr.ensta.aefd.toolbox.tools.analysis.graph.Graph;
import fr.ensta.aefd.toolbox.tools.analysis.graph.GraphAnalysis;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class TempTest {
    public static void addConnectedComponent(String nodePrefix, Graph<String, String> targetGraph, int numNodes, int numTransitions) {
        int i;
        Random random = new Random();
        String[] nodeNames = new String[numNodes];
        for (i = 0; i < nodeNames.length; ++i) {
            nodeNames[i] = nodePrefix + String.valueOf(i);
        }
        targetGraph.addNode(nodeNames[0]);
        for (i = 1; i < nodeNames.length; ++i) {
            int j = random.nextInt(i);
            if (random.nextBoolean()) {
                targetGraph.addTransition(nodeNames[i], nodeNames[j]);
                continue;
            }
            targetGraph.addTransition(nodeNames[j], nodeNames[i]);
        }
        for (int n = 0; n < numTransitions - numNodes - 1; ++n) {
            targetGraph.addTransition(nodeNames[random.nextInt(numNodes)], nodeNames[random.nextInt(numNodes)]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        void var6_9;
        String source;
        Random random = new Random();
        System.out.println("Testing extraction of connected components");
        System.out.println("------------------------------------------");
        System.out.println();
        System.out.println("1) Building graph");
        Graph<String, String> graph = new Graph<String, String>();
        String[] prefixes = new String[10];
        for (int i = 0; i < prefixes.length; ++i) {
            prefixes[i] = String.valueOf((char)(65 + i));
            TempTest.addConnectedComponent(prefixes[i], graph, i + 1, i * 2);
            System.out.println("   Added component " + prefixes[i]);
        }
        System.out.println();
        System.out.println("2) Computing connnected components");
        List<Graph<Object, Object>> connectedComponents = GraphAnalysis.extractConnectedComponents(graph);
        System.out.println();
        System.out.println("   Result");
        System.out.println("     Found " + connectedComponents.size() + " components (expected " + prefixes.length + ")");
        for (Graph graph2 : connectedComponents) {
            System.out.print("      ");
            for (String string : graph2.getNodes()) {
                System.out.print(" " + graph2.nodeToString(string));
            }
            System.out.println();
        }
        System.out.println();
        String string = source = prefixes[random.nextInt(prefixes.length)] + "0";
        while (var6_9.equals(source)) {
            String string2 = prefixes[random.nextInt(prefixes.length)] + "0";
        }
        System.out.println("3) Connecting " + source + " to " + (String)var6_9);
        graph.addTransition(source, (String)var6_9);
        System.out.println();
        System.out.println("4) Computing connnected components");
        connectedComponents = GraphAnalysis.extractConnectedComponents(graph);
        System.out.println();
        System.out.println("   Result");
        System.out.println("     Found " + connectedComponents.size() + " components (expected " + (prefixes.length - 1) + ")");
        for (Graph graph3 : connectedComponents) {
            System.out.print("      ");
            for (String string3 : graph3.getNodes()) {
                System.out.print(" " + graph3.nodeToString(string3));
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("5) Connecting A0 to every x0");
        for (Iterator<Object> iterator : prefixes) {
            graph.addTransition(prefixes[0] + String.valueOf(0), iterator + String.valueOf(0));
        }
        System.out.println();
        System.out.println("4) Computing connnected components");
        connectedComponents = GraphAnalysis.extractConnectedComponents(graph);
        System.out.println();
        System.out.println("   Result");
        System.out.println("     Found " + connectedComponents.size() + " components (expected " + 1 + ")");
        for (Graph graph4 : connectedComponents) {
            System.out.print("      ");
            for (String string4 : graph4.getNodes()) {
                System.out.print(" " + graph4.nodeToString(string4));
            }
            System.out.println();
        }
        System.out.println();
    }
}

