/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis.graph;

import fr.ensta.aefd.toolbox.tools.analysis.graph.Graph;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class GraphAnalysis {
    public static <N, L> List<Graph<N, L>> extractConnectedComponents(Graph<N, L> graph) {
        LinkedList components = new LinkedList();
        Graph.Fan fan = graph.getFan();
        LinkedList<List> currentConnections = new LinkedList<List>();
        for (Object currentNode : graph.getNodes()) {
            currentConnections.clear();
            List list = fan.out(currentNode);
            List fanIn = fan.in(currentNode);
            block1: for (List list2 : components) {
                for (Object componentNode : list2) {
                    if (!list.contains(componentNode) && !fanIn.contains(componentNode)) continue;
                    currentConnections.add(list2);
                    continue block1;
                }
            }
            if (currentConnections.isEmpty()) {
                LinkedList newComponent = new LinkedList();
                newComponent.add(currentNode);
                components.add(newComponent);
                continue;
            }
            List hostComponent = (List)currentConnections.removeFirst();
            hostComponent.add(currentNode);
            for (List oldComponent : currentConnections) {
                hostComponent.addAll(oldComponent);
                components.remove(oldComponent);
            }
        }
        LinkedList<Graph<N, L>> result = new LinkedList<Graph<N, L>>();
        for (List list : components) {
            Graph connectedGraph = graph.subGraph(t -> component.contains(t.source));
            for (Object e : list) {
                connectedGraph.addNode(e);
            }
            result.add(connectedGraph);
        }
        return result;
    }

    public static <N, L> boolean pathHasCycle(List<Graph.Transition<N, L>> path) {
        if (path.isEmpty()) {
            return false;
        }
        HashSet nodes = new HashSet();
        nodes.add(path.get((int)0).source);
        for (Graph.Transition<N, L> transition : path) {
            if (nodes.add(transition.target)) continue;
            return true;
        }
        return false;
    }
}

