/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.obs.ASynchronousCommunicationAction;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.obs.InformalAction;
import obp.explorer.runtime.obs.SynchronousCommunicationAction;
import obp.simulation.observer.DiagramObservable;
import obp.simulation.observer.DiagramObserver;
import obp.ui.sequence.HorizontalLine;
import obp.ui.sequence.LifeLine;
import obp.ui.sequence.Message;
import obp.ui.sequence.Sequence;

public class DiagramModel
implements DiagramObservable {
    private List<DiagramObserver> observers = new ArrayList<DiagramObserver>();
    private final List<Action> trace;
    private final SymbolsTable symbols;
    private final Sequence sequence = new Sequence();
    private final HashMap<Short, LifeLine> lifeLineMap = new LinkedHashMap<Short, LifeLine>();
    private final ArrayDeque<Message> messageMap = new ArrayDeque();
    private int currentX = 50;
    private int deltaX = 150;
    private int currentOrder = 0;

    public Sequence toSequence(List<Action> trace, SymbolsTable symbols) {
        Sequence seq = new DiagramModel(trace, symbols).generate();
        if (seq != null) {
            this.notifyObserver(seq);
        }
        return seq;
    }

    public DiagramModel(List<Action> trace, SymbolsTable symbols) {
        this.trace = trace;
        this.symbols = symbols;
    }

    private Sequence generate() {
        for (Action action : this.trace) {
            for (AtomicAction atomicAction : action.atomicActions) {
                if (atomicAction instanceof ASynchronousCommunicationAction) {
                    ASynchronousCommunicationAction async = (ASynchronousCommunicationAction)atomicAction;
                    String label = async.message.toString();
                    switch (async.commType) {
                        case 2: {
                            Message message = new Message(this.sequence, label);
                            message.setSource(this.getOrCreateLifeLine(async.behaviorId));
                            message.setSourceOrder(this.currentOrder);
                            this.messageMap.add(message);
                            ++this.currentOrder;
                            break;
                        }
                        case 1: {
                            Message message = this.retreiveMatchingMessage(label);
                            if (message == null) {
                                message = new Message(this.sequence, label);
                            }
                            message.setTarget(this.getOrCreateLifeLine(async.behaviorId));
                            message.setTargetOrder(this.currentOrder);
                            this.sequence.addItem(message);
                            this.messageMap.remove(async.message);
                            ++this.currentOrder;
                            break;
                        }
                        default: {
                            System.out.println("Asynchronous communication type '" + async.commType + "' isn't supported.");
                            break;
                        }
                    }
                    continue;
                }
                if (atomicAction instanceof SynchronousCommunicationAction) {
                    SynchronousCommunicationAction sync = (SynchronousCommunicationAction)atomicAction;
                    Message message = new Message(this.sequence, this.symbols.getChannelName(sync.channelId));
                    message.setSource(this.getOrCreateLifeLine(sync.sourceId));
                    message.setSourceOrder(this.currentOrder);
                    message.setTarget(this.getOrCreateLifeLine(sync.targetId));
                    message.setTargetOrder(this.currentOrder);
                    this.sequence.addItem(message);
                    ++this.currentOrder;
                    continue;
                }
                if (atomicAction instanceof InformalAction) {
                    InformalAction informal = (InformalAction)atomicAction;
                    HorizontalLine line = new HorizontalLine(this.sequence, this.symbols.getInformalName(informal.informalId));
                    line.setOrder(this.currentOrder);
                    this.sequence.addItem(line);
                    ++this.currentOrder;
                    continue;
                }
                String type = atomicAction == null ? "null" : atomicAction.getClass().getSimpleName();
                System.err.println("AtomicAction type '" + type + "' isn't visible in sequence diagram traces.");
            }
        }
        if (this.messageMap.size() > 0) {
            Iterator<Object> iterator = this.messageMap.iterator();
            while (iterator.hasNext()) {
                Message message = (Message)iterator.next();
                this.sequence.addItem(message);
                iterator.remove();
            }
        }
        for (LifeLine lifeLine : this.lifeLineMap.values()) {
            this.sequence.addLine(lifeLine);
        }
        for (short i = 0; i < this.symbols.getObserversStartIndex(); i = (short)(i + 1)) {
            LifeLine lifeLine;
            if (this.lifeLineMap.containsKey(i)) continue;
            lifeLine = this.getOrCreateLifeLine(i);
            this.sequence.addLine(lifeLine);
        }
        return this.sequence;
    }

    private Message retreiveMatchingMessage(String label) {
        Iterator<Message> iterator = this.messageMap.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            if (!label.equals(message.getLabel())) continue;
            iterator.remove();
            return message;
        }
        return null;
    }

    private LifeLine getOrCreateLifeLine(short id) {
        LifeLine result = this.lifeLineMap.get(id);
        if (result == null) {
            result = new LifeLine(this.sequence, this.symbols.getBehaviorName(id), this.currentX);
            this.lifeLineMap.put(id, result);
            this.currentX += this.deltaX;
        }
        return result;
    }

    @Override
    public void addObserver(DiagramObserver obs) {
        this.observers.add(obs);
    }

    @Override
    public void removeObserver() {
        this.observers.clear();
    }

    @Override
    public void notifyObserver(Sequence sequence) {
        for (DiagramObserver obs : this.observers) {
            obs.update(sequence);
        }
    }
}

