/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.ContainerDecl;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.Statement;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public abstract class NodeDecl
extends ContainerDecl
implements BoostObject {
    private final List<ParamPortDecl> portList = new ArrayList<ParamPortDecl>();
    private final List<LocalPortDecl> localPortList = new ArrayList<LocalPortDecl>();
    private Statement initAction;

    public NodeDecl() {
    }

    protected NodeDecl(Boost boost) {
        super(boost);
        for (PortDecl oneChild : BoostUtil.readObjectList((Boost)boost, ParamPortDecl.class)) {
            this.portList.add((ParamPortDecl)oneChild);
        }
        for (PortDecl oneChild : BoostUtil.readObjectList((Boost)boost, LocalPortDecl.class)) {
            this.localPortList.add((LocalPortDecl)oneChild);
        }
        this.initAction = (Statement)boost.readObject(Statement.class);
    }

    public List<ParamPortDecl> getPortList() {
        return Collections.unmodifiableList(this.portList);
    }

    public int getPortCount() {
        return this.portList.size();
    }

    public ParamPortDecl getPort(int index) {
        if (index < 0 || index >= this.getPortCount()) {
            return null;
        }
        return this.portList.get(index);
    }

    public void addPort(ParamPortDecl newValue) {
        this.addPort(this.getPortCount(), newValue);
    }

    public void addPort(int index, ParamPortDecl newValue) {
        this.portList.add(index, newValue);
    }

    public ParamPortDecl setPort(int index, ParamPortDecl newValue) {
        return this.portList.set(index, newValue);
    }

    public void addAllPort(Collection<ParamPortDecl> toAddList) {
        for (ParamPortDecl newValue : toAddList) {
            this.addPort(this.getPortCount(), newValue);
        }
    }

    public void removePort(ParamPortDecl value) {
        int index = this.portList.indexOf(value);
        if (index >= 0) {
            this.removePort(index);
        }
    }

    public void removePort(int index) {
        this.portList.remove(index);
    }

    public List<LocalPortDecl> getLocalPortList() {
        return Collections.unmodifiableList(this.localPortList);
    }

    public int getLocalPortCount() {
        return this.localPortList.size();
    }

    public LocalPortDecl getLocalPort(int index) {
        if (index < 0 || index >= this.getLocalPortCount()) {
            return null;
        }
        return this.localPortList.get(index);
    }

    public void addLocalPort(LocalPortDecl newValue) {
        this.addLocalPort(this.getLocalPortCount(), newValue);
    }

    public void addLocalPort(int index, LocalPortDecl newValue) {
        this.localPortList.add(index, newValue);
    }

    public LocalPortDecl setLocalPort(int index, LocalPortDecl newValue) {
        return this.localPortList.set(index, newValue);
    }

    public void addAllLocalPort(Collection<LocalPortDecl> toAddList) {
        for (LocalPortDecl newValue : toAddList) {
            this.addLocalPort(this.getLocalPortCount(), newValue);
        }
    }

    public void removeLocalPort(LocalPortDecl value) {
        int index = this.localPortList.indexOf(value);
        if (index >= 0) {
            this.removeLocalPort(index);
        }
    }

    public void removeLocalPort(int index) {
        this.localPortList.remove(index);
    }

    public Statement getInitAction() {
        return this.initAction;
    }

    public void setInitAction(Statement newValue) {
        if (this.initAction == null ? newValue != null : !this.initAction.equals(newValue)) {
            this.initAction = newValue;
        }
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.portList);
        BoostUtil.writeObjectCollection((Boost)boost, this.localPortList);
        boost.writeObject((BoostObject)this.initAction);
    }

    @Override
    public abstract void accept(ModelVisitor var1);
}

