/*
 * Decompiled with CFR 0.152.
 */
package obp.cc2fiacre;

import java.util.Stack;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.Exp;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.Program;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.ValuedField;
import obp.fiacre.util.FiacreUtil;
import obp.literal.AnyLiteral;
import obp.literal.ArrayLiteral;
import obp.literal.BooleanLiteral;
import obp.literal.ConstantReference;
import obp.literal.IntegerLiteral;
import obp.literal.Literal;
import obp.literal.LiteralField;
import obp.literal.LiteralVisitor;
import obp.literal.RecordLiteral;
import obp.literal.StringLiteral;
import obp.literal.UnionLiteral;
import obp.util.CDLUtil;

public class LiteralToFiacre
implements LiteralVisitor {
    private final Program program;
    private final Stack<Exp> literalStack = new Stack();

    public static Exp toFiacre(Literal literal, Program program) {
        LiteralToFiacre transformer = new LiteralToFiacre(program);
        literal.accept(transformer);
        return transformer.literalStack.pop();
    }

    private LiteralToFiacre(Program program) {
        this.program = program;
    }

    @Override
    public void visitAnyLiteral(AnyLiteral toVisit) {
        throw new IllegalArgumentException("Can't print an 'any' literal.");
    }

    @Override
    public void visitStringLiteral(StringLiteral toVisit) {
        throw new IllegalArgumentException("String literal aren't supported in Fiacre.");
    }

    @Override
    public void visitBooleanLiteral(BooleanLiteral toVisit) {
        BoolLiteral literal = new BoolLiteral();
        literal.setValue(toVisit.isValue());
        this.literalStack.push(literal);
    }

    @Override
    public void visitIntegerLiteral(IntegerLiteral toVisit) {
        NatLiteral literal = new NatLiteral();
        literal.setValue(toVisit.getValue());
        this.literalStack.push(literal);
    }

    @Override
    public void visitConstantReference(ConstantReference toVisit) {
        ConstantRef ref = new ConstantRef();
        ConstantDecl decl = FiacreUtil.findDeclaration(toVisit.getName(), ConstantDecl.class, this.program);
        if (decl == null) {
            throw new IllegalArgumentException("Constant named '" + toVisit.getName() + "' doesn't exist in program.");
        }
        ref.setDecl(decl);
        this.literalStack.push(ref);
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral toVisit) {
        this.checkType(toVisit.getTypeName());
        InlineArray inlineArray = new InlineArray();
        for (Literal literal : toVisit.getValueList()) {
            literal.accept(this);
            inlineArray.addElem(this.literalStack.pop());
        }
        this.literalStack.push(inlineArray);
    }

    @Override
    public void visitLiteralField(LiteralField toVisit) {
    }

    @Override
    public void visitRecordLiteral(RecordLiteral toVisit) {
        this.checkType(toVisit.getTypeName());
        InlineRecord inlineRecord = new InlineRecord();
        for (LiteralField field : toVisit.getFieldList()) {
            ValuedField valuedField = new ValuedField();
            valuedField.setField(field.getName());
            field.getValue().accept(this);
            valuedField.setValue(this.literalStack.pop());
            inlineRecord.addValue(valuedField);
        }
        this.literalStack.push(inlineRecord);
    }

    @Override
    public void visitUnionLiteral(UnionLiteral toVisit) {
        this.checkType(toVisit.getTypeName());
        ConstrExp constrExp = new ConstrExp();
        constrExp.setName(toVisit.getName());
        if (toVisit.getValue() != null) {
            toVisit.getValue().accept(this);
            constrExp.setArg(this.literalStack.pop());
        }
        this.literalStack.push(constrExp);
    }

    private void checkType(String typeName) {
        if (CDLUtil.BUILT_IN_TYPES.contains(typeName)) {
            return;
        }
        if (FiacreUtil.findDeclaration(typeName, TypeDecl.class, this.program) == null) {
            throw new IllegalArgumentException("Type named '" + typeName + "' doesn't exist in program.");
        }
    }
}

