/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.printer.fiacre;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.HelperBus;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.Exp;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;

public class BooleanVariablesArray
extends HelperBus.Abstract {
    public static final String ID_PREFIX = "VAR_";
    private AEFDModel model;
    private String arrayTypeName;
    private String arrayName;
    private final LinkedList<ConstantDecl> declarationList = new LinkedList();
    private final Map<AEFDBooleanVariable, ConstantDecl> declarationMap = new HashMap<AEFDBooleanVariable, ConstantDecl>();
    private final Map<AEFDAutomate, ArgumentVariable> argumentMap = new HashMap<AEFDAutomate, ArgumentVariable>();
    private Array array;
    private TypeDecl arrayDeclaration;
    private TypeId arrayTypeId;

    public BooleanVariablesArray(HelperBus helper) {
        super(helper);
    }

    public void generate(AEFDModel model, String arrayTypeName, String arrayName) {
        this.model = model;
        this.arrayTypeName = arrayTypeName;
        this.arrayName = arrayName;
        this.declarationList.clear();
        this.declarationMap.clear();
        this.generateConstants();
        this.generateArray();
        this.generateArguments();
    }

    private void generateConstants() {
        for (AEFDBooleanVariable var : this.model.getAllVariables()) {
            String ID = ID_PREFIX + var.getName();
            ConstantDecl declaration = new ConstantDecl();
            declaration.setName(ID);
            declaration.setType((Type)this.helper.builder.natType());
            declaration.setValue((Exp)this.helper.builder.literal(this.model.getAllVariables().indexOf(var)));
            this.declarationList.add(declaration);
            this.declarationMap.put(var, declaration);
        }
    }

    private void generateArray() {
        this.array = new Array();
        this.array.setSize((Exp)this.helper.builder.literal(this.model.getAllVariables().size()));
        this.array.setType((Type)this.helper.builder.boolType());
        this.arrayDeclaration = new TypeDecl();
        this.arrayDeclaration.setName(this.arrayTypeName);
        this.arrayDeclaration.setIs((Type)this.array);
        this.arrayTypeId = new TypeId();
        this.arrayTypeId.setDecl(this.arrayDeclaration);
    }

    public ArgumentVariable buildArgument() {
        ArgumentVariable argument = new ArgumentVariable();
        argument.setName(this.arrayName);
        argument.setType((Type)this.arrayTypeId);
        argument.setRead(true);
        argument.setWrite(true);
        argument.setRef(true);
        return argument;
    }

    private void generateArguments() {
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            this.argumentMap.put(automate, this.buildArgument());
        }
    }

    public TypeDecl getArrayDeclaration() {
        return this.arrayDeclaration;
    }

    public TypeId getArrayTypeId() {
        return this.arrayTypeId;
    }

    public LinkedList<ConstantDecl> getAllConstantDeclarations() {
        return this.declarationList;
    }

    public ArgumentVariable getArgument(AEFDAutomate owner) {
        return this.argumentMap.get(owner);
    }

    private VarRef buildArrayRef(AEFDAutomate owner) {
        VarRef arrayRef = new VarRef();
        arrayRef.setDecl((Variable)this.getArgument(owner));
        return arrayRef;
    }

    private ConstantRef buildIndex(AEFDBooleanVariable index) {
        ConstantRef indexExp = new ConstantRef();
        indexExp.setDecl(this.declarationMap.get(index));
        return indexExp;
    }

    private ArrayPattern buildArrayPattern(VarRef arrayRef, AEFDBooleanVariable index) {
        ConstantRef indexExp = this.buildIndex(index);
        ArrayPattern pattern = new ArrayPattern();
        pattern.setArray((Pattern)arrayRef);
        pattern.setIndex((Exp)indexExp);
        return pattern;
    }

    private ArrayPattern buildArrayPattern(AEFDAutomate owner, AEFDBooleanVariable index) {
        VarRef arrayRef = this.buildArrayRef(owner);
        return this.buildArrayPattern(arrayRef, index);
    }

    public Statement buildAffectation(VarRef arrayRef, AEFDBooleanVariable index, boolean newValue) {
        return this.helper.builder.assign((Pattern)this.buildArrayPattern(arrayRef, index), (Exp)this.helper.builder.literal(newValue));
    }

    public Statement buildAffectation(AEFDAutomate owner, AEFDBooleanVariable index, boolean newValue) {
        return this.helper.builder.assign((Pattern)this.buildArrayPattern(owner, index), (Exp)this.helper.builder.literal(newValue));
    }

    public Exp buildEvaluation(VarRef arrayRef, AEFDBooleanVariable index) {
        ConstantRef indexExp = this.buildIndex(index);
        ArrayElem eval = new ArrayElem();
        eval.setArray((Exp)arrayRef);
        eval.setIndex((Exp)indexExp);
        return eval;
    }

    public Exp buildEvaluation(AEFDAutomate owner, AEFDBooleanVariable index) {
        VarRef arrayRef = this.buildArrayRef(owner);
        return this.buildEvaluation(arrayRef, index);
    }

    public LocalVariable buildLocalVariable() {
        LocalVariable lv = new LocalVariable();
        lv.setName(this.arrayName);
        lv.setType((Type)this.arrayTypeId);
        return lv;
    }
}

