/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.runtime.temp;

import fr.ensta.aefd.model.AEFDModelObject;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.runtime.AEFDRuntime;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import fr.ensta.aefd.toolbox.AEFDToolbox;
import fr.ensta.aefd.toolbox.demos.DemosDefaultSettings;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import plug.core.IFiredTransition;

public class DemoRuntimeCas0 {
    public static void main(String[] args) throws Exception {
        String path = args.length == 1 ? args[0] : "../res/";
        DemosDefaultSettings.check((String)path);
        AEFDToolbox toolbox = new AEFDToolbox();
        toolbox.parser.addFile(path + "PN a SAL Cas1.txt");
        toolbox.parser.addFile(path + "PN a SAL Cas1 Preuve.txt");
        toolbox.parser.parse();
        if (toolbox.finalizeModel()) {
            toolbox.trimModel();
            toolbox.moveEventToInitPhase("Init");
        }
        AEFDRuntime runtime = new AEFDRuntime();
        runtime.loadModel(toolbox.model);
        System.out.println(runtime.printer.getLongInfosString());
        String[] initialVariableValues = new String[]{"IND_Zone5_1_Libre", "CTL_Zone1_Libre", "IND_Zone1_Libre", "CTL_Zone5_1_Libre", "IND_Zone5_Libre", "IND_Zone3_Libre", "CTL_Zone3_Libre", "CTL_Zone5_Libre"};
        runtime.provideInitialVariableValues(initialVariableValues);
        Set<AEFDRuntimeSystemState> initialConfigurations = runtime.initialConfigurations();
        AEFDRuntimeSystemState currentConfiguration = (AEFDRuntimeSystemState)((Object)initialConfigurations.stream().findAny().get());
        System.out.println("Initial: " + runtime.printer.getSystemStateLongString(currentConfiguration));
        System.out.println();
        Random rng = new Random();
        for (int i = 0; i < 15; ++i) {
            Collection<AEFDTransition> transitionSet = runtime.fireableTransitionsFrom(currentConfiguration);
            if (transitionSet.isEmpty()) {
                System.out.println("Dead-Lock ! (oops)");
                break;
            }
            System.out.println("Fireable transitions:");
            int transitionIndex = 0;
            int fireIndex = rng.nextInt(transitionSet.size());
            AEFDTransition transitionToFire = null;
            for (AEFDTransition transition : transitionSet) {
                if (transitionIndex++ == fireIndex) {
                    transitionToFire = transition;
                    System.out.print("<Fire> ");
                }
                System.out.println(runtime.printer.getAEFDString((AEFDModelObject)transition));
            }
            IFiredTransition<AEFDRuntimeSystemState, AEFDTransition> firedTransition = runtime.fireOneTransition(currentConfiguration, transitionToFire);
            if (firedTransition == null || firedTransition.getTargets().size() == 0) {
                System.out.println("No target after firing? That shouldn't be possible...");
                break;
            }
            System.out.println("Reached " + firedTransition.getTargets().size() + " targets.");
            System.out.println("Picking one (targetSet.iterator().next()).");
            currentConfiguration = (AEFDRuntimeSystemState)((Object)firedTransition.getTargets().iterator().next());
            System.out.println("Step " + i + ": " + runtime.printer.getSystemStateLongString(currentConfiguration));
            System.out.println();
        }
    }
}

