/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.DeclarationWithParameters;
import org.cte.ABCD.model.declarations.DeclarationWithVariables;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.kernel.TypedElement;
import org.cte.ABCD.model.statements.Block;

public class FunctionDecl
implements NamedDeclaration,
TypedElement,
DeclarationWithParameters,
DeclarationWithVariables {
    private Block body;
    private String name;
    private Type type;
    private final List<ParameterDecl> parametersList = new ArrayList<ParameterDecl>();
    private final List<VariableDecl> variablesList = new ArrayList<VariableDecl>();

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block newValue) {
        if (this.body == null ? newValue != null : !this.body.equals(newValue)) {
            this.body = newValue;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type newValue) {
        if (this.type == null ? newValue != null : !this.type.equals(newValue)) {
            this.type = newValue;
        }
    }

    @Override
    public List<ParameterDecl> getParametersList() {
        return Collections.unmodifiableList(this.parametersList);
    }

    @Override
    public int getParametersCount() {
        return this.parametersList.size();
    }

    @Override
    public ParameterDecl getParameters(int index) {
        if (index < 0 || index >= this.getParametersCount()) {
            return null;
        }
        return this.parametersList.get(index);
    }

    @Override
    public void addParameters(ParameterDecl newValue) {
        this.addParameters(this.getParametersCount(), newValue);
    }

    @Override
    public void addParameters(int index, ParameterDecl newValue) {
        this.parametersList.add(index, newValue);
    }

    @Override
    public ParameterDecl setParameters(int index, ParameterDecl newValue) {
        return this.parametersList.set(index, newValue);
    }

    @Override
    public void addAllParameters(Collection<ParameterDecl> toAddList) {
        for (ParameterDecl newValue : toAddList) {
            this.addParameters(this.getParametersCount(), newValue);
        }
    }

    @Override
    public void removeParameters(ParameterDecl value) {
        int index = this.parametersList.indexOf(value);
        if (index >= 0) {
            this.removeParameters(index);
        }
    }

    @Override
    public void removeParameters(int index) {
        this.parametersList.remove(index);
    }

    @Override
    public void addParametersAndOpposite(ParameterDecl newValue) {
        this.addParameters(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllParametersAndOpposite(Collection<ParameterDecl> toAddList) {
        for (ParameterDecl newValue : toAddList) {
            this.addParametersAndOpposite(this.getParametersCount(), newValue);
        }
    }

    @Override
    public void addParametersAndOpposite(int index, ParameterDecl newValue) {
        this.addParameters(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public ParameterDecl setParametersAndOpposite(int index, ParameterDecl newValue) {
        ParameterDecl oldValue = this.parametersList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removeParametersAndOpposite(ParameterDecl removed) {
        this.removeParameters(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removeParametersAndOpposite(int index) {
        ParameterDecl removed = this.parametersList.get(index);
        this.removeParameters(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public List<VariableDecl> getVariablesList() {
        return Collections.unmodifiableList(this.variablesList);
    }

    @Override
    public int getVariablesCount() {
        return this.variablesList.size();
    }

    @Override
    public VariableDecl getVariables(int index) {
        if (index < 0 || index >= this.getVariablesCount()) {
            return null;
        }
        return this.variablesList.get(index);
    }

    @Override
    public void addVariables(VariableDecl newValue) {
        this.addVariables(this.getVariablesCount(), newValue);
    }

    @Override
    public void addVariables(int index, VariableDecl newValue) {
        this.variablesList.add(index, newValue);
    }

    @Override
    public VariableDecl setVariables(int index, VariableDecl newValue) {
        return this.variablesList.set(index, newValue);
    }

    @Override
    public void addAllVariables(Collection<VariableDecl> toAddList) {
        for (VariableDecl newValue : toAddList) {
            this.addVariables(this.getVariablesCount(), newValue);
        }
    }

    @Override
    public void removeVariables(VariableDecl value) {
        int index = this.variablesList.indexOf(value);
        if (index >= 0) {
            this.removeVariables(index);
        }
    }

    @Override
    public void removeVariables(int index) {
        this.variablesList.remove(index);
    }

    @Override
    public void addVariablesAndOpposite(VariableDecl newValue) {
        this.addVariables(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllVariablesAndOpposite(Collection<VariableDecl> toAddList) {
        for (VariableDecl newValue : toAddList) {
            this.addVariablesAndOpposite(this.getVariablesCount(), newValue);
        }
    }

    @Override
    public void addVariablesAndOpposite(int index, VariableDecl newValue) {
        this.addVariables(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public VariableDecl setVariablesAndOpposite(int index, VariableDecl newValue) {
        VariableDecl oldValue = this.variablesList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removeVariablesAndOpposite(VariableDecl removed) {
        this.removeVariables(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removeVariablesAndOpposite(int index) {
        VariableDecl removed = this.variablesList.get(index);
        this.removeVariables(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitFunctionDecl(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof FunctionDecl)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((FunctionDecl)that, cache);
    }

    protected boolean equalsFeatures(FunctionDecl that, IdentityHashMap<Object, Object> cache) {
        int i;
        int l1size = 0;
        int l2size = 0;
        if (!this.body.equalsCached(that.body, cache)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.parametersList != null) {
            if (that.parametersList == null) {
                return false;
            }
            l1size = this.parametersList.size();
            if (l1size != (l2size = that.parametersList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.parametersList.get(i).equalsCached(that.parametersList.get(i), cache)) continue;
                return false;
            }
        }
        if (this.variablesList != null) {
            if (that.variablesList == null) {
                return false;
            }
            l1size = this.variablesList.size();
            if (l1size != (l2size = that.variablesList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.variablesList.get(i).equalsCached(that.variablesList.get(i), cache)) continue;
                return false;
            }
        }
        return true;
    }
}

