/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.transform;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.analysis.GraphAsMapAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.SingleAutomateAnalysis;
import fr.ensta.aefd.toolbox.tools.handler.ModelHandles;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FlatMultipleTokens {
    private ModelHandles handles;
    private AEFDModel model;
    private SingleAutomateAnalysis automateAnalyser = new SingleAutomateAnalysis();
    private GraphAsMapAnalysis<String> graphAsMapAnalyser = new GraphAsMapAnalysis();
    private LinkedList<AEFDAutomate> scheduledForTransform = new LinkedList();
    private AEFDAutomate currentAutomate;
    private Map<String, Set<String>> fanout;

    public void transform(AEFDModel model, ModelHandles handles) {
        this.model = model;
        this.handles = handles;
        handles.log("Splitting automates with multiple tokens");
        this.scheduledForTransform.clear();
        for (AEFDAutomate automate : model.getAllAutomates()) {
            if (automate.getNumberOfTokens() <= 1) continue;
            this.scheduledForTransform.add(automate);
        }
        handles.log("Found " + this.scheduledForTransform.size() + " to split");
        while (!this.scheduledForTransform.isEmpty()) {
            this.flatNext();
        }
        handles.log("Done splitting automates with multiple tokens");
        handles.logPrettyPrint();
    }

    private void flatNext() {
        this.currentAutomate = this.scheduledForTransform.removeFirst();
        this.automateAnalyser.setAutomate(this.currentAutomate);
        this.fanout = this.automateAnalyser.computeFanout();
        this.fanout.remove(this.currentAutomate.getInitialPlace());
        this.graphAsMapAnalyser.setFanout(this.fanout);
        LinkedList<AEFDAutomate> newAutomates = new LinkedList<AEFDAutomate>();
        Set<Set<String>> connectedComponents = this.graphAsMapAnalyser.computeConnectedComponents();
        if (connectedComponents.size() != this.currentAutomate.getNumberOfTokens()) {
            throw new IllegalStateException("Automate: " + this.currentAutomate.getName() + " #tokens: " + this.currentAutomate.getNumberOfTokens() + " #connectedComposants: " + connectedComponents.size() + " cannot flatten");
        }
        int index = 1;
        for (Set<String> connectedComponent : connectedComponents) {
            AEFDAutomate newAutomate = this.buildNewAutomate(connectedComponent, index++);
            newAutomates.addLast(newAutomate);
        }
        this.handles.replaceAutomate(this.currentAutomate, newAutomates, "multiple to single token transformation");
    }

    private AEFDAutomate buildNewAutomate(Set<String> connectedComponent, int index) {
        AEFDAutomate result = new AEFDAutomate(this.currentAutomate.getName() + "_" + index);
        result.setInitialPlace(this.currentAutomate.getInitialPlace());
        result.setNumberOfTokens(1);
        for (AEFDTransition transition : this.currentAutomate.getTransitionSet()) {
            if (!connectedComponent.contains(transition.getPlaceTarget())) continue;
            result.addTransition(transition);
        }
        return result;
    }
}

