/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.handler;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDTransition;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class SilentRemoveUselessTransitions {
    private AEFDModel model;
    private Set<AEFDAutomate> affectedAutomates = new HashSet<AEFDAutomate>();
    private int removedTransitionsCount;

    public void setModel(AEFDModel model) {
        this.model = model;
    }

    public void remove() {
        this.removedTransitionsCount = 0;
        this.affectedAutomates.clear();
        LinkedList<AEFDTransition> transitionsToRemove = new LinkedList<AEFDTransition>();
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            for (AEFDTransition transition : automate.getTransitionSet()) {
                if (transition.getAction().getActionList().size() != 0 || !transition.getPlaceSource().equals(transition.getPlaceTarget())) continue;
                if (transitionsToRemove.isEmpty()) {
                    this.affectedAutomates.add(automate);
                }
                transitionsToRemove.add(transition);
            }
            for (AEFDTransition transition : transitionsToRemove) {
                automate.removeTransition(transition);
                ++this.removedTransitionsCount;
            }
            transitionsToRemove.clear();
        }
    }

    public int getRemovedTransitionsCount() {
        return this.removedTransitionsCount;
    }

    public Set<AEFDAutomate> getAffectedAutomates() {
        return this.affectedAutomates;
    }
}

