/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis.basic;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.analysis.util.FetchTransitionReadVariables;
import fr.ensta.aefd.toolbox.tools.analysis.util.FetchTransitionReceivedEvents;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReadVariablesAnalysis
extends AEFDModelVisitor.Stub {
    private final Set<AEFDBooleanVariable> readVariables = new HashSet<AEFDBooleanVariable>();
    private final Map<AEFDAutomate, Set<AEFDBooleanVariable>> globalReadVariables = new HashMap<AEFDAutomate, Set<AEFDBooleanVariable>>();
    private final Map<AEFDBooleanVariable, Set<AEFDAutomate>> globalReaders = new HashMap<AEFDBooleanVariable, Set<AEFDAutomate>>();
    private final Map<AEFDFunctionalEntity, Map<AEFDAutomate, Set<AEFDBooleanVariable>>> eventSpecificReadVariables = new HashMap<AEFDFunctionalEntity, Map<AEFDAutomate, Set<AEFDBooleanVariable>>>();
    private final Map<AEFDFunctionalEntity, Map<AEFDBooleanVariable, Set<AEFDAutomate>>> eventSpecificReaders = new HashMap<AEFDFunctionalEntity, Map<AEFDBooleanVariable, Set<AEFDAutomate>>>();
    private final FetchTransitionReceivedEvents eventFetcher = new FetchTransitionReceivedEvents();
    private final FetchTransitionReadVariables variableFetcher = new FetchTransitionReadVariables();
    private AEFDAutomate currentAutomate;

    private void initialize(AEFDModel model) {
        this.readVariables.clear();
        this.globalReadVariables.clear();
        this.globalReaders.clear();
        this.eventSpecificReadVariables.clear();
        this.eventSpecificReadVariables.clear();
        for (AEFDFunctionalEntity event : model.getAllFunctionalEntity()) {
            HashMap localMap = new HashMap();
            for (AEFDAutomate automate : model.getAllAutomates()) {
                localMap.put(automate, new HashSet());
            }
            this.eventSpecificReadVariables.put(event, localMap);
            HashMap reverseLocalMap = new HashMap();
            for (AEFDBooleanVariable variable : model.getAllVariables()) {
                reverseLocalMap.put(variable, new HashSet());
            }
            this.eventSpecificReaders.put(event, reverseLocalMap);
        }
        for (AEFDAutomate automate : model.getAllAutomates()) {
            this.globalReadVariables.put(automate, new HashSet());
        }
        for (AEFDBooleanVariable variable : model.getAllVariables()) {
            this.globalReaders.put(variable, new HashSet());
        }
    }

    public void analyze(AEFDModel model) {
        this.initialize(model);
        model.accept(this);
    }

    public Set<AEFDBooleanVariable> getReadVariables() {
        return this.readVariables;
    }

    public Set<AEFDBooleanVariable> getReadVariables(AEFDAutomate automate) {
        return this.globalReadVariables.get(automate);
    }

    public Set<AEFDBooleanVariable> getReadVariablesOn(AEFDAutomate automate, AEFDFunctionalEntity event) {
        return this.eventSpecificReadVariables.get(event).get(automate);
    }

    public Set<AEFDAutomate> getReaders(AEFDBooleanVariable variable) {
        return this.globalReaders.get(variable);
    }

    public Set<AEFDAutomate> getReadersOn(AEFDBooleanVariable variable, AEFDFunctionalEntity event) {
        return this.eventSpecificReaders.get(event).get(variable);
    }

    @Override
    public void visitModel(AEFDModel model) {
        for (AEFDAutomate automate : model.getAllAutomates()) {
            automate.accept(this);
        }
    }

    @Override
    public void visitAutomate(AEFDAutomate automate) {
        this.currentAutomate = automate;
        for (AEFDTransition transition : automate.getTransitionSet()) {
            transition.accept(this);
        }
    }

    @Override
    public void visitTransition(AEFDTransition transition) {
        for (AEFDBooleanVariable variable : this.variableFetcher.getReadVariables(transition)) {
            this.readVariables.add(variable);
            this.globalReadVariables.get(this.currentAutomate).add(variable);
            this.globalReaders.get(variable).add(this.currentAutomate);
            for (AEFDFunctionalEntity event : this.eventFetcher.getReceivedEvents(transition)) {
                this.eventSpecificReadVariables.get(event).get(this.currentAutomate).add(variable);
                this.eventSpecificReaders.get(event).get(variable).add(this.currentAutomate);
            }
        }
    }
}

