/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.transform;

import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.analysis.VariableUsageAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.basic.ReceivedEventsAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.basic.SentEventsAnalysis;
import fr.ensta.aefd.toolbox.tools.handler.ModelHandles;
import fr.ensta.aefd.toolbox.tools.handler.SilentRemoveEvent;
import fr.ensta.aefd.toolbox.tools.handler.SilentRemoveUselessTransitions;
import fr.ensta.aefd.toolbox.tools.handler.SilentRemoveVariable;
import java.util.LinkedList;
import java.util.List;

public class RemoveUnused {
    private AEFDModel model;
    private ModelHandles handles;
    private ReceivedEventsAnalysis receivedEvents = new ReceivedEventsAnalysis();
    private SentEventsAnalysis sentEvents = new SentEventsAnalysis();
    private SilentRemoveEvent removeEvent = new SilentRemoveEvent();
    private SilentRemoveVariable removeVariable = new SilentRemoveVariable();
    private SilentRemoveUselessTransitions removeTransitions = new SilentRemoveUselessTransitions();
    private int totalRemovedActionCount;

    public void transform(AEFDModel model, ModelHandles handles) {
        this.model = model;
        this.handles = handles;
        handles.log("Analysing events and variable usages");
        this.receivedEvents.analyze(model);
        this.sentEvents.analyze(model);
        VariableUsageAnalysis varAnalyser = new VariableUsageAnalysis();
        varAnalyser.analyse(model);
        this.totalRemovedActionCount = 0;
        LinkedList<AEFDFunctionalEntity> unusedFEs = new LinkedList<AEFDFunctionalEntity>();
        unusedFEs.addAll(this.sentEvents.getSentEvents());
        unusedFEs.removeAll(this.receivedEvents.getReceivedEvents());
        handles.log("Found " + unusedFEs.size() + " sent but never received events");
        this.removeEvent.setModel(model);
        for (AEFDFunctionalEntity event : unusedFEs) {
            this.removeEvent.remove(event);
            handles.log("Removed event " + event.getIdentifier() + " related actions (" + this.removeEvent.getRemovedActionCount() + ")");
            this.totalRemovedActionCount += this.removeEvent.getRemovedActionCount();
        }
        List<AEFDBooleanVariable> unusedVariables = varAnalyser.getVariables(VariableUsageAnalysis.VarDiagnostic.NeverRead);
        handles.log("Found " + unusedVariables.size() + " never read variables");
        this.removeVariable.setModel(model);
        for (AEFDBooleanVariable variable : unusedVariables) {
            this.removeVariable.remove(variable);
            handles.log("Removed variable " + variable.getName() + " related actions (" + this.removeVariable.getRemovedActionCount() + ")");
            this.totalRemovedActionCount += this.removeVariable.getRemovedActionCount();
        }
        handles.log("Done removing useless actions (" + this.totalRemovedActionCount + ")");
        this.removeTransitions.setModel(model);
        this.removeTransitions.remove();
        this.totalRemovedActionCount += this.removeTransitions.getRemovedTransitionsCount();
        if (this.removeTransitions.getRemovedTransitionsCount() > 0) {
            handles.log("Consequently removed " + this.removeTransitions.getRemovedTransitionsCount() + " transitions (no action, source == target) in " + this.removeTransitions.getAffectedAutomates().size() + " distinct automates.");
        }
        handles.logPrettyPrint();
    }

    public int getTotalRemovedActionCount() {
        return this.totalRemovedActionCount;
    }
}

