/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.transform;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDCondition;
import fr.ensta.aefd.model.AEFDEvent;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.model.meta.ModelReferences;
import fr.ensta.aefd.toolbox.tools.analysis.VariableUsageAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.basic.ReceivedEventsAnalysis;
import fr.ensta.aefd.toolbox.tools.analysis.basic.SentEventsAnalysis;
import fr.ensta.aefd.toolbox.tools.handler.ModelHandles;
import java.util.Collection;
import java.util.LinkedList;

public class EnvGenerator {
    public static final String ENVIRONMENT_NAME = "Environment";
    public static final String IDLE_PLACE = "0";
    private AEFDModel model;
    private ModelHandles handles;
    private ModelReferences references;
    private final ReceivedEventsAnalysis receivedEvents = new ReceivedEventsAnalysis();
    private final SentEventsAnalysis sentEvents = new SentEventsAnalysis();
    private final VariableUsageAnalysis varAnalyser = new VariableUsageAnalysis();
    private AEFDAutomate environment;
    private Collection<AEFDFunctionalEntity> environmentRestrictions = null;

    public void setEnvironmentRestictions(Collection<AEFDFunctionalEntity> environmentRestictions) {
        this.environmentRestrictions = environmentRestictions;
    }

    public void addEnvToModel(AEFDModel model, ModelHandles handles, ModelReferences references) {
        this.model = model;
        this.handles = handles;
        this.references = references;
        this.receivedEvents.analyze(model);
        this.sentEvents.analyze(model);
        this.varAnalyser.analyse(model);
        this.environment = new AEFDAutomate(ENVIRONMENT_NAME);
        this.environment.setInitialPlace(IDLE_PLACE);
        this.fillEnvironment();
        handles.addAutomate(this.environment, "Automatically generated environment");
    }

    private void fillEnvironment() {
        LinkedList<AEFDFunctionalEntity> modelInputs = new LinkedList<AEFDFunctionalEntity>();
        modelInputs.addAll(this.receivedEvents.getReceivedEvents());
        modelInputs.removeAll(this.sentEvents.getSentEvents());
        if (this.environmentRestrictions != null && !this.environmentRestrictions.isEmpty()) {
            if (!modelInputs.contains(this.environmentRestrictions)) {
                System.err.println("environment alternatives force already written events!");
            }
            modelInputs.retainAll(this.environmentRestrictions);
        }
        for (AEFDFunctionalEntity input : modelInputs) {
            this.environment.addTransition(this.createEnvTransition(input));
        }
    }

    private AEFDTransition createEnvTransition(AEFDFunctionalEntity input) {
        if (input.getPrefix().requiresSuffix()) {
            AEFDBooleanVariable variable = this.references.getBooleanVariable(input);
            boolean newValue = variable.getBooleanValue(input.getSuffix());
            return this.createEnvTransition(input, variable, newValue);
        }
        return this.createEnvTransition(input, null, null);
    }

    private AEFDTransition createEnvTransition(AEFDFunctionalEntity input, AEFDBooleanVariable booleanVariable, Boolean newValue) {
        AEFDEvent event = new AEFDEvent();
        event.setBoolExp(AEFDBooleanExpression.TRUE);
        AEFDCondition condition = new AEFDCondition();
        AEFDActionSequence actionSequence = new AEFDActionSequence();
        if (booleanVariable != null) {
            condition.setBoolExp(new AEFDBooleanExpression.VariableEvaluation(booleanVariable, newValue == false));
            AEFDAction.Affectation affectation = new AEFDAction.Affectation(booleanVariable, newValue);
            actionSequence.addAction(affectation);
        } else {
            condition.setBoolExp(AEFDBooleanExpression.TRUE);
        }
        AEFDAction.SendEvent sendEvent = new AEFDAction.SendEvent();
        sendEvent.setFunctionalEntity(input);
        actionSequence.addAction(sendEvent);
        AEFDTransition transition = new AEFDTransition(IDLE_PLACE, IDLE_PLACE);
        transition.setEvent(event);
        transition.setCondition(condition);
        transition.setAction(actionSequence);
        return transition;
    }
}

