/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class Graph<N, L> {
    private List<Transition<N, L>> transitions = new LinkedList<Transition<N, L>>();
    private List<N> nodes = new LinkedList<N>();
    private List<L> labels = new LinkedList<L>();
    private Function<N, String> nodeToString = Object::toString;
    private Function<L, String> labelToString = Object::toString;

    public void setNodeToString(Function<N, String> nodeToString) {
        this.nodeToString = nodeToString;
    }

    public String nodeToString(N node) {
        return this.nodeToString.apply(node);
    }

    public void setLabelToString(Function<L, String> labelToString) {
        this.labelToString = labelToString;
    }

    public String labelToString(L label) {
        return this.labelToString.apply(label);
    }

    public List<N> getNodes() {
        return this.nodes;
    }

    public boolean hasNode(N node) {
        return this.getNodes().contains(node);
    }

    public boolean addNode(N node) {
        if (this.hasNode(node)) {
            return false;
        }
        this.getNodes().add(node);
        return true;
    }

    public List<L> getLabels() {
        return this.labels;
    }

    public boolean hasLabel(L label) {
        return this.getLabels().contains(label);
    }

    public boolean addLabel(L label) {
        if (this.hasLabel(label)) {
            return false;
        }
        this.getLabels().add(label);
        return true;
    }

    public List<Transition<N, L>> getTransitions() {
        return this.transitions;
    }

    public boolean addTransition(Transition<N, L> transition) {
        if (this.getTransitions().contains(transition)) {
            return false;
        }
        this.addNode(transition.source);
        this.addNode(transition.target);
        this.addLabel(transition.label);
        this.getTransitions().add(transition);
        return true;
    }

    public boolean addTransition(N source, N target, L label) {
        Transition<N, L> newTransition = new Transition<N, L>(source, target, label);
        return this.addTransition(newTransition);
    }

    public boolean addTransition(N source, N target) {
        return this.addTransition(source, target, null);
    }

    public void importNodes(Graph<N, L> other) {
        for (N node : other.getNodes()) {
            this.addNode(node);
        }
    }

    public void importLabels(Graph<N, L> other) {
        for (L label : other.getLabels()) {
            this.addLabel(label);
        }
    }

    public void importNodesAndLabels(Graph<N, L> other) {
        this.importNodes(other);
        this.importLabels(other);
    }

    public Graph<N, L> mergeWith(Graph<N, L> other) {
        Graph<N, L> result = new Graph<N, L>();
        for (Transition<N, L> transition : this.getTransitions()) {
            this.addTransition(transition);
        }
        for (Transition<N, L> transition : other.getTransitions()) {
            this.addTransition(transition);
        }
        result.setNodeToString(this.nodeToString);
        result.setLabelToString(this.labelToString);
        return result;
    }

    public Graph<N, L> subGraph(Predicate<Transition<N, L>> predicate) {
        Graph<N, L> result = new Graph<N, L>();
        for (Transition<N, L> transition : this.getTransitions()) {
            if (!predicate.test(transition)) continue;
            result.addTransition(transition);
        }
        result.setNodeToString(this.nodeToString);
        result.setLabelToString(this.labelToString);
        return result;
    }

    public Graph<N, L> removeNode(N node) {
        return this.subGraph(t -> t.source != node && t.target != node);
    }

    public Graph<N, L> removeLabel(L label) {
        return this.subGraph(t -> t.label != label);
    }

    public Graph<N, L> modGraph(Function<Transition<N, L>, Transition<N, L>> modifier) {
        Graph<N, L> result = new Graph<N, L>();
        for (Transition<N, L> transition : this.getTransitions()) {
            result.addTransition(modifier.apply(transition));
        }
        result.setNodeToString(this.nodeToString);
        result.setLabelToString(this.labelToString);
        return result;
    }

    public Graph<N, L> reverseGraph() {
        return this.modGraph(t -> new Transition(t.target, t.source, t.label));
    }

    public Map<N, List<N>> toMap(boolean trim) {
        HashMap resultMap = new HashMap();
        for (N n : this.getNodes()) {
            resultMap.put(n, new LinkedList());
        }
        for (Transition transition : this.getTransitions()) {
            List fanOut = (List)resultMap.get(transition.source);
            if (fanOut.contains(transition.target)) continue;
            fanOut.add(transition.target);
        }
        if (trim) {
            for (Object object : this.getNodes()) {
                if (!((List)resultMap.get(object)).isEmpty()) continue;
                resultMap.remove(object);
            }
        }
        return resultMap;
    }

    public static <N, L> Graph<N, L> graphFromMap(Map<N, Collection<N>> map) {
        Graph<N, Object> result = new Graph<N, Object>();
        for (N source : map.keySet()) {
            for (N target : map.get(source)) {
                result.addTransition(source, target, null);
            }
        }
        return result;
    }

    public Map<N, Map<L, List<N>>> toMapWithLabels(boolean trim) {
        HashMap resultMap = new HashMap();
        for (N n : this.getNodes()) {
            resultMap.put(n, new HashMap());
            HashMap transitionMap = new HashMap();
            for (L label : this.getLabels()) {
                transitionMap.put(label, new LinkedList());
            }
        }
        for (Transition transition : this.getTransitions()) {
            List fanOut = (List)((Map)resultMap.get(transition.source)).get(transition.label);
            if (fanOut.contains(transition.target)) continue;
            fanOut.add(transition.target);
        }
        if (trim) {
            for (Object object : this.getNodes()) {
                for (L label : this.getLabels()) {
                    if (!((List)((Map)resultMap.get(object)).get(label)).isEmpty()) continue;
                    ((Map)resultMap.get(object)).remove(label);
                }
                if (!((Map)resultMap.get(object)).isEmpty()) continue;
                resultMap.remove(object);
            }
        }
        return resultMap;
    }

    public static <N, L> Graph<N, L> graphFromMapWithLabels(Map<N, Map<L, Collection<N>>> map) {
        Graph<N, L> result = new Graph<N, L>();
        for (N source : map.keySet()) {
            Map<L, Collection<N>> labeledFanout = map.get(source);
            for (L label : labeledFanout.keySet()) {
                for (N target : labeledFanout.get(label)) {
                    result.addTransition(source, target, label);
                }
            }
        }
        return result;
    }

    public String toTGFString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.getNodes().size(); ++i) {
            result.append(i).append(" ").append(this.nodeToString(this.getNodes().get(i))).append("\n");
        }
        result.append("#\n");
        for (Transition<N, L> transition : this.getTransitions()) {
            result.append(this.getNodes().indexOf(transition.source)).append(" ").append(this.getNodes().indexOf(transition.target));
            if (transition.label != null) {
                result.append(" ").append(this.labelToString(transition.label));
            }
            result.append("\n");
        }
        return result.toString();
    }

    public Fan getFan() {
        return new Fan();
    }

    public LabeledFan getLabeledFan() {
        return new LabeledFan();
    }

    public class LabeledFan {
        private Map<N, Map<L, List<N>>> graphAsMap;
        private Map<N, Map<L, List<N>>> reversedGraphAsMap;

        public LabeledFan() {
            this.graphAsMap = Graph.this.toMapWithLabels(false);
            Graph reversedGraph = Graph.this.reverseGraph();
            reversedGraph.importNodesAndLabels(Graph.this);
            this.reversedGraphAsMap = reversedGraph.toMapWithLabels(false);
        }

        public Map<L, List<N>> out(N source) {
            return this.graphAsMap.get(source);
        }

        public Map<L, List<N>> in(N target) {
            return this.reversedGraphAsMap.get(target);
        }
    }

    public class Fan {
        private Map<N, List<N>> graphAsMap;
        private Map<N, List<N>> reversedGraphAsMap;

        public Fan() {
            this.update();
        }

        public void update() {
            this.graphAsMap = Graph.this.toMap(false);
            Graph reversedGraph = Graph.this.reverseGraph();
            reversedGraph.importNodesAndLabels(Graph.this);
            this.reversedGraphAsMap = reversedGraph.toMap(false);
        }

        public List<N> out(N source) {
            return this.graphAsMap.get(source);
        }

        public List<N> in(N target) {
            return this.reversedGraphAsMap.get(target);
        }
    }

    public static class Transition<N, L> {
        public N source;
        public N target;
        public L label;

        public Transition(N source, N target, L label) {
            this.source = source;
            this.target = target;
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Transition other = (Transition)o;
            if (!this.source.equals(other.source)) {
                return false;
            }
            if (!this.target.equals(other.target)) {
                return false;
            }
            return !(this.label == null ? other.label != null : !this.label.equals(other.label));
        }
    }
}

