/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.geometry;

import org.xid.basics.geometry.Geometry;
import org.xid.basics.geometry.Polyline;

public class Manhattan
extends Polyline {
    private static final float[] unusedRect = new float[4];

    public static boolean startsHorizontally(float[] connectionPoints) {
        float x2 = 0.0f;
        float y2 = 0.0f;
        float bestLen = -1.0f;
        boolean hor = false;
        boolean swap = true;
        int i = 0;
        for (int j = 1; j < connectionPoints.length; j += 2) {
            float x1 = x2;
            float y1 = y2;
            x2 = connectionPoints[i];
            y2 = connectionPoints[j];
            if (i > 0) {
                float dy;
                float dx = Math.abs(x1 - x2);
                float len = dx + (dy = Math.abs(y1 - y2));
                if (len > bestLen) {
                    bestLen = dx + dy;
                    hor = dx >= dy == swap;
                }
                swap = !swap;
            }
            i += 2;
        }
        return hor;
    }

    public static int segmentDirection(float[] connectionPoints, int segmentIndex) {
        int i = segmentIndex * 2;
        if (i < 0 || i + 3 >= connectionPoints.length) {
            return -1;
        }
        boolean hor = Manhattan.startsHorizontally(connectionPoints);
        if (segmentIndex % 2 == 1) {
            hor = !hor;
        }
        float x1 = connectionPoints[i];
        float y1 = connectionPoints[i + 1];
        float x2 = connectionPoints[i + 2];
        float y2 = connectionPoints[i + 3];
        if (hor) {
            return x2 >= x1 ? 0 : 4;
        }
        return y2 >= y1 ? 2 : 6;
    }

    public static void movePointTo(float[] connectionPoints, float[] point, int index) {
        Manhattan.movePointTo(connectionPoints, point[0], point[1], index, unusedRect);
    }

    public static void movePointTo(float[] connectionPoints, float x, float y, int index) {
        Manhattan.movePointTo(connectionPoints, x, y, index, unusedRect);
    }

    public static void movePointTo(float[] connectionPoints, float[] point, int index, float[] impactedRectangle) {
        Manhattan.movePointTo(connectionPoints, point[0], point[1], index, impactedRectangle);
    }

    public static void movePointTo(float[] connectionPoints, float x, float y, int index, float[] impactedRectangle) {
        int i = index * 2;
        boolean hor = Manhattan.startsHorizontally(connectionPoints);
        if (index % 2 == 1) {
            hor = !hor;
        }
        Geometry.rectangleMergeWithPoint(impactedRectangle, connectionPoints[i], connectionPoints[i + 1]);
        connectionPoints[i] = x;
        connectionPoints[i + 1] = y;
        Geometry.rectangleMergeWithPoint(impactedRectangle, x, y);
        if (i - 2 >= 0) {
            Geometry.rectangleMergeWithPoint(impactedRectangle, connectionPoints[i - 2], connectionPoints[i - 1]);
            if (!hor) {
                connectionPoints[i - 1] = y;
            } else {
                connectionPoints[i - 2] = x;
            }
        }
        if (i + 3 < connectionPoints.length) {
            Geometry.rectangleMergeWithPoint(impactedRectangle, connectionPoints[i + 2], connectionPoints[i + 3]);
            if (hor) {
                connectionPoints[i + 3] = y;
            } else {
                connectionPoints[i + 2] = x;
            }
        }
    }

    public static float[] adjustBothEnds(float[] polyline, float[] point1, float[] rect1, float[] point2, float[] rect2, float offset, float[] impactedRect) {
        polyline = Manhattan.adjustOneEnd(polyline, point1, rect1, offset, true, impactedRect);
        polyline = Manhattan.adjustOneEnd(polyline, point2, rect2, offset, false, impactedRect);
        return polyline;
    }

    public static float[] adjustOneEnd(float[] polyline, float[] point, float[] rectangle, float offset, boolean start, float[] impactedRect) {
        int numPoints = Manhattan.numPoints(polyline);
        int i1 = start ? 0 : numPoints - 1;
        int i2 = i1 + (start ? 1 : -1);
        float[] p1 = Manhattan.getPoint(polyline, i1);
        float[] p2 = Manhattan.getPoint(polyline, i2);
        if (Geometry.distanceSquared(point, p1) <= 1.0E-4f) {
            return polyline;
        }
        int rectSide = Geometry.positionOfPointRelativeToRectangle(point, rectangle);
        int segDir = Manhattan.segmentDirection(polyline, start ? 0 : numPoints - 2);
        if (!start) {
            segDir = Geometry.oppositeDirection(segDir);
        }
        if (!Geometry.isParallelTo(rectSide, segDir)) {
            return Manhattan.adjustOneEnd(Manhattan.addEndSegment(polyline, start), point, rectangle, offset, start, impactedRect);
        }
        Manhattan.movePointTo(polyline, point[0], point[1], i1, impactedRect);
        p1 = Manhattan.getPoint(polyline, i1);
        p2 = Manhattan.getPoint(polyline, i2);
        float ux = Geometry.xDelta(rectSide);
        float uy = Geometry.yDelta(rectSide);
        float dotProd = ux * (p2[0] - p1[0]) + uy * (p2[1] - p1[1]);
        if (dotProd < offset) {
            Manhattan.movePointTo(polyline, point[0] + ux * offset, point[1] + uy * offset, i2, impactedRect);
        }
        return polyline;
    }

    public static float[] route(float[] p1, int dir1, float offset1, float[] p2, int dir2, float offset2) {
        boolean dir1Horiz = Geometry.isParallelTo(dir1, 0);
        float[] u1 = Geometry.unitVector(dir1);
        if (Geometry.isParallelTo(dir1, dir2)) {
            if (dir1 == dir2) {
                float[] points = new float[]{p1[0], p1[1], p1[0] + Geometry.xDelta(dir1) * offset1, p1[1] + Geometry.yDelta(dir1) * offset1, p2[0] + Geometry.xDelta(dir2) * offset2, p2[1] + Geometry.yDelta(dir2) * offset2, p2[0], p2[1]};
                if (Geometry.dotProduct(p1, u1) >= Geometry.dotProduct(p2, u1)) {
                    if (dir1Horiz) {
                        points[4] = points[2];
                    } else {
                        points[5] = points[3];
                    }
                } else if (dir1Horiz) {
                    points[2] = points[4];
                } else {
                    points[3] = points[5];
                }
                return points;
            }
            float xm = (p1[0] + p2[0]) / 2.0f;
            float ym = (p1[1] + p2[1]) / 2.0f;
            if (Geometry.dotProduct(p1, u1) >= Geometry.dotProduct(p2, u1)) {
                float[] points = new float[]{p1[0], p1[1], p1[0] + Geometry.xDelta(dir1) * offset1, p1[1] + Geometry.yDelta(dir1) * offset1, xm, ym, xm, ym, p2[0] + Geometry.xDelta(dir2) * offset2, p2[1] + Geometry.yDelta(dir2) * offset2, p2[0], p2[1]};
                if (dir1Horiz) {
                    points[4] = points[2];
                    points[6] = points[8];
                } else {
                    points[5] = points[3];
                    points[7] = points[9];
                }
                return points;
            }
            if (dir1Horiz) {
                return new float[]{p1[0], p1[1], xm, p1[1], xm, p2[1], p2[0], p2[1]};
            }
            return new float[]{p1[0], p1[1], p1[0], ym, p2[0], ym, p2[0], p2[1]};
        }
        float[] u2 = Geometry.unitVector(dir2);
        if (Geometry.dotProduct(p1, u1) >= Geometry.dotProduct(p2, u1) || Geometry.dotProduct(p2, u2) >= Geometry.dotProduct(p1, u2)) {
            float[] points = new float[]{p1[0], p1[1], p1[0] + Geometry.xDelta(dir1) * offset1, p1[1] + Geometry.yDelta(dir1) * offset1, 0.0f, 0.0f, p2[0] + Geometry.xDelta(dir2) * offset2, p2[1] + Geometry.yDelta(dir2) * offset2, p2[0], p2[1]};
            if (dir1Horiz) {
                points[4] = points[2];
                points[5] = points[7];
            } else {
                points[4] = points[6];
                points[5] = points[3];
            }
            return points;
        }
        return new float[]{p1[0], p1[1], dir1Horiz ? p2[0] : p1[0], dir1Horiz ? p1[1] : p2[1], p2[0], p2[1]};
    }

    public static float[] routeFor2Rects(float[] p1, float[] rect1, float offset1, float[] p2, float[] rect2, float offset2) {
        int segmentIndex;
        int dir2;
        int dir1 = Geometry.positionOfPointRelativeToRectangle(p1, rect1);
        float[] points = Manhattan.route(p1, dir1, offset1, p2, dir2 = Geometry.positionOfPointRelativeToRectangle(p2, rect2), offset2);
        if (Geometry.numPoints(points) == 6 && (Manhattan.segmentIntersectsRectangle(points, segmentIndex = 2, rect1) || Manhattan.segmentIntersectsRectangle(points, segmentIndex, rect2))) {
            int dir = Manhattan.segmentDirection(points, segmentIndex);
            float xMax = Math.max(rect1[2], rect2[2]);
            float yMax = Math.max(rect1[3], rect2[3]);
            int iPoint = segmentIndex;
            float offset = Math.min(offset1, offset2);
            if (Geometry.isParallelTo(dir, 0)) {
                Manhattan.movePointTo(points, points[iPoint * 2], yMax + offset, iPoint);
            } else {
                Manhattan.movePointTo(points, xMax + offset, points[iPoint * 2 + 1], iPoint);
            }
        }
        return points;
    }

    @Deprecated
    public static float[] route(float[] p1, float[] rect1, float[] p2, float[] rect2) {
        return Manhattan.routeFor2Rects(p1, rect1, 10.0f, p2, rect2, 10.0f);
    }

    public static float[] removeSegment(float[] polyline, int segmentIndex, float[] impactedRect) {
        int i = segmentIndex * 2;
        float x1 = polyline[i];
        float y1 = polyline[i + 1];
        float x2 = polyline[i + 2];
        float y2 = polyline[i + 3];
        float xm = (x1 + x2) / 2.0f;
        float ym = (y1 + y2) / 2.0f;
        Manhattan.movePointTo(polyline, xm, ym, segmentIndex, impactedRect);
        Manhattan.movePointTo(polyline, xm, ym, segmentIndex + 1, impactedRect);
        float[] newConnectionPoints = new float[polyline.length - 4];
        int i1 = 0;
        int i2 = 0;
        while (i1 < polyline.length) {
            if (i1 == i) {
                i1 += 4;
            }
            newConnectionPoints[i2] = polyline[i1];
            ++i1;
            ++i2;
        }
        return newConnectionPoints;
    }

    public static float[] discardSmallSegments(float[] polyline, float threshold) {
        return Manhattan.discardSmallSegments(polyline, threshold, unusedRect);
    }

    public static float[] discardSmallSegments(float[] polyline, float threshold, float[] impactedRect) {
        int numPoints = Manhattan.numPoints(polyline);
        if (numPoints <= 4) {
            return polyline;
        }
        int iSegment = Manhattan.findSmallSegment(polyline, threshold, 1);
        if (iSegment == -1) {
            return polyline;
        }
        if (iSegment == numPoints - 2) {
            return polyline;
        }
        float[] newConnectionPoints = Manhattan.removeSegment(polyline, iSegment, impactedRect);
        return Manhattan.discardSmallSegments(newConnectionPoints, threshold);
    }
}

