/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cte.ABCD.ABCDReplacer;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.builder.Builder;
import org.cte.ABCD.builder.ComplexBuilder;
import org.cte.ABCD.compiler.PrimitiveUtils;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.TypedElement;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.types.TimerType;

public class TInlineTimer {
    private ABCDSystem currentSystem;
    private Builder builder;
    ComplexBuilder timBuilder;
    ChannelTypeDecl[] timChannelType = new ChannelTypeDecl[2];
    private Map<TypedElement, Port[]> timPortsMap = new LinkedHashMap<TypedElement, Port[]>();
    private Map<TypedElement, Map<ProcessInstance, List<ArgumentMap>>> sharedTimerUsageMap = new LinkedHashMap<TypedElement, Map<ProcessInstance, List<ArgumentMap>>>();
    private Map<TypedElement, List<ProcessInstance>> localTimerUsageMap = new LinkedHashMap<TypedElement, List<ProcessInstance>>();
    private Map<List<Integer>, ProcessDecl> sizeTimerMap = new LinkedHashMap<List<Integer>, ProcessDecl>();

    public void runOn(ABCDSystem sys) throws Exception {
        this.currentSystem = sys;
        this.removeUnusedTimers();
        this.builder = new Builder(sys.getCoreTypesList());
        this.timBuilder = new ComplexBuilder(sys.getCoreTypesList());
        this.timChannelType[0] = this.builder.syncChannelType("timNat", this.builder.natType());
        this.timChannelType[1] = this.builder.syncChannelType("timNone", this.builder.noneType());
        this.inlineTimerAPI();
        this.computeUsageMap();
        this.inlineLocalTimers();
        this.inlineSharedTimers();
        this.currentSystem.addAllProcesses(this.sizeTimerMap.values());
        if (!this.sizeTimerMap.isEmpty()) {
            this.currentSystem.addAllChannelTypes(Arrays.asList(this.timChannelType));
        }
    }

    public void inlineLocalTimers() throws Exception {
        ABCDReplacer replacer = new ABCDReplacer();
        for (TypedElement tim : this.localTimerUsageMap.keySet()) {
            Port[] ports = this.timPortsMap.get(tim);
            Integer[] clientA = new Integer[]{ports[0] == null ? 0 : 1, ports[1] == null ? 0 : 1, ports[2] == null ? 0 : 1};
            replacer.addRemove(tim);
            List<Integer> clients = Arrays.asList(clientA);
            ProcessDecl process = this.sizeTimerMap.get(clients);
            if (process == null) {
                String name = "tim_" + clients.get(0) + "_" + clients.get(1) + "_" + clients.get(2);
                process = this.timBuilder.timerDiscrete(name, clients.get(0), clients.get(1), clients.get(2));
                this.sizeTimerMap.put(clients, process);
            }
            for (ProcessInstance instance : this.localTimerUsageMap.get(tim)) {
                ChannelDecl[] chans = this.createTimerChannels(tim, clients);
                this.currentSystem.addAllChannels(Arrays.asList(chans));
                this.currentSystem.addCompositionAndOpposite(this.builder.instance(process, Arrays.copyOfRange(chans, 0, clients.get(0) + clients.get(1)), Arrays.copyOfRange(chans, clients.get(0) + clients.get(1), chans.length), null));
                if (ports[0] != null) {
                    instance.addOutputs(this.builder.portMap(ports[0], chans[0]));
                }
                if (ports[1] != null) {
                    instance.addOutputs(this.builder.portMap(ports[1], chans[clientA[0]]));
                }
                if (ports[2] == null) continue;
                instance.addInputs(this.builder.portMap(ports[2], chans[clientA[0] + clientA[1]]));
            }
        }
        this.currentSystem.accept(replacer);
    }

    public void inlineSharedTimers() throws Exception {
        ABCDReplacer replacer = new ABCDReplacer();
        for (TypedElement tim : this.sharedTimerUsageMap.keySet()) {
            List<Integer> clients = this.computeClients(tim);
            if (clients.get(0) == 0 && clients.get(1) == 0 && clients.get(2) == 0) continue;
            replacer.addRemove(tim);
            ProcessDecl process = this.sizeTimerMap.get(clients);
            if (process == null) {
                String name = "tim_" + clients.get(0) + "_" + clients.get(1) + "_" + clients.get(2);
                process = this.timBuilder.timerDiscrete(name, clients.get(0), clients.get(1), clients.get(2));
                this.sizeTimerMap.put(clients, process);
            }
            ChannelDecl[] chans = this.createTimerChannels(tim, clients);
            this.currentSystem.addAllChannels(Arrays.asList(chans));
            this.currentSystem.addCompositionAndOpposite(this.builder.instance(process, Arrays.copyOfRange(chans, 0, clients.get(0) + clients.get(1)), Arrays.copyOfRange(chans, clients.get(0) + clients.get(1), chans.length), null));
            this.replaceTimerBindings(tim, chans, clients, replacer);
        }
        this.currentSystem.accept(replacer);
    }

    private void replaceTimerBindings(TypedElement tim, ChannelDecl[] chans, List<Integer> clients, ABCDReplacer replacer) {
        Map<ProcessInstance, List<ArgumentMap>> oldBindings = this.sharedTimerUsageMap.get(tim);
        int startIdx = 0;
        int stopIdx = clients.get(0);
        int timeoutIdx = clients.get(0) + clients.get(1);
        for (ProcessInstance instance : oldBindings.keySet()) {
            for (ArgumentMap arg : oldBindings.get(instance)) {
                replacer.addRemove(arg);
                Port[] ports = this.timPortsMap.get(arg.getFormal());
                if (ports == null) continue;
                if (ports[0] != null) {
                    instance.addOutputs(this.builder.portMap(ports[0], chans[startIdx++]));
                }
                if (ports[1] != null) {
                    instance.addOutputs(this.builder.portMap(ports[1], chans[stopIdx++]));
                }
                if (ports[2] == null) continue;
                instance.addInputs(this.builder.portMap(ports[2], chans[timeoutIdx++]));
            }
        }
    }

    private ChannelDecl[] createTimerChannels(TypedElement tim, List<Integer> clients) {
        int i;
        ChannelDecl[] chans = new ChannelDecl[clients.get(0) + clients.get(1) + clients.get(2)];
        NamedDeclaration mTim = tim instanceof NamedDeclaration ? (NamedDeclaration)((Object)tim) : null;
        for (i = 0; i < clients.get(0); ++i) {
            chans[i] = this.builder.syncChannel(mTim.getName() + "Start" + i, this.timChannelType[0]);
        }
        for (i = clients.get(0).intValue(); i < clients.get(0) + clients.get(1); ++i) {
            chans[i] = this.builder.syncChannel(mTim.getName() + "Stop" + i, this.timChannelType[1]);
        }
        for (i = clients.get(0) + clients.get(1); i < clients.get(0) + clients.get(1) + clients.get(2); ++i) {
            chans[i] = this.builder.syncChannel(mTim.getName() + "Timeout" + i, this.timChannelType[1]);
        }
        return chans;
    }

    private List<Integer> computeClients(TypedElement tim) {
        Map<ProcessInstance, List<ArgumentMap>> instancesMap = this.sharedTimerUsageMap.get(tim);
        if (instancesMap == null) {
            return Arrays.asList(0, 0, 0);
        }
        Integer[] clients = new Integer[]{0, 0, 0};
        for (List<ArgumentMap> args : instancesMap.values()) {
            for (ArgumentMap arg : args) {
                Port[] ports = this.timPortsMap.get(arg.getFormal());
                if (ports == null) continue;
                Integer[] integerArray = clients;
                Integer.valueOf(integerArray[0] + (ports[0] == null ? 0 : 1));
                integerArray = clients;
                Integer.valueOf(integerArray[1] + (ports[1] == null ? 0 : 1));
                integerArray = clients;
                Integer.valueOf(integerArray[2] + (ports[2] == null ? 0 : 1));
            }
        }
        return Arrays.asList(clients);
    }

    private void computeUsageMap() {
        List<VariableDecl> semaphores = this.sharedTimers();
        for (VariableDecl sem : semaphores) {
            this.sharedTimerUsageMap.put(sem, new LinkedHashMap());
        }
        for (ProcessInstance instance : this.currentSystem.getCompositionList()) {
            instance.accept(new ABCDVisitor.Stub(){
                ProcessInstance currentInstance;
                ArgumentMap currentArgMap;

                @Override
                public void visitProcessInstance(ProcessInstance i) {
                    this.currentInstance = i;
                    for (ArgumentMap args : i.getArgumentsList()) {
                        args.accept(this);
                    }
                }

                @Override
                public void visitArgumentMap(ArgumentMap arg) {
                    this.currentArgMap = arg;
                    arg.getActual().accept(this);
                }

                @Override
                public void visitReference(Reference ref) {
                    ref.getRef().accept(this);
                }

                @Override
                public void visitVariableDecl(VariableDecl var) {
                    if (var.getType() instanceof TimerType) {
                        Map timPerInstance = (Map)TInlineTimer.this.sharedTimerUsageMap.get(var);
                        List args = (List)timPerInstance.get(this.currentInstance);
                        if (args == null) {
                            timPerInstance.put(this.currentInstance, Arrays.asList(this.currentArgMap));
                        } else {
                            args.add(this.currentArgMap);
                        }
                    }
                }
            });
        }
    }

    private List<VariableDecl> sharedTimers() {
        ArrayList<VariableDecl> list = new ArrayList<VariableDecl>();
        for (VariableDecl var : this.currentSystem.getVariablesList()) {
            if (!(var.getType() instanceof TimerType)) continue;
            list.add(var);
        }
        return list;
    }

    public void inlineTimerAPI() {
        for (ProcessInstance instance : this.currentSystem.getCompositionList()) {
            List<VariableDecl> tims = PrimitiveUtils.localTimerList(instance.getProcess());
            for (VariableDecl variableDecl : tims) {
                List<ProcessInstance> instances = this.localTimerUsageMap.get(variableDecl);
                if (instances == null) {
                    instances = new ArrayList<ProcessInstance>();
                    this.localTimerUsageMap.put(variableDecl, instances);
                }
                instances.add(instance);
            }
        }
        for (ProcessDecl process : this.currentSystem.getProcessesList()) {
            int id = 1;
            for (TypedElement typedElement : PrimitiveUtils.timerList(process)) {
                this.timPortsMap.put(typedElement, this.inlineTimerIn(typedElement, id++, process));
            }
        }
    }

    public Port[] inlineTimerIn(TypedElement timer, int id, ProcessDecl process) {
        ABCDReplacer replacer = new ABCDReplacer();
        Port[] ports = new Port[3];
        replacer.addRemove(timer);
        List<SpecialTypeStmt> stmts = PrimitiveUtils.startOnTimer(timer, process);
        if (!stmts.isEmpty()) {
            ports[0] = this.builder.port("start" + id, this.builder.natType(), false);
            for (SpecialTypeStmt specialTypeStmt : stmts) {
                replacer.addReplacement(specialTypeStmt, this.builder.output(ports[0], specialTypeStmt.getArguments(0)));
            }
            process.addPortsAndOpposite(ports[0]);
        }
        if (!(stmts = PrimitiveUtils.stopOnTimer(timer, process)).isEmpty()) {
            ports[1] = this.builder.port("stop" + id, this.builder.noneType(), false);
            for (Statement statement : stmts) {
                replacer.addReplacement(statement, this.builder.output(ports[1]));
            }
            process.addPortsAndOpposite(ports[1]);
        }
        if (!(stmts = PrimitiveUtils.timeoutOnTimer(timer, process)).isEmpty()) {
            ports[2] = this.builder.port("timeout" + id, this.builder.noneType(), true);
            for (Statement statement : stmts) {
                replacer.addReplacement(statement, this.builder.input(ports[2]));
            }
            process.addPortsAndOpposite(ports[2]);
        }
        process.accept(replacer);
        return ports;
    }

    public void removeUnusedTimers() {
        ABCDReplacer replacer = new ABCDReplacer();
        for (ProcessDecl process : this.currentSystem.getProcessesList()) {
            for (TypedElement tim : PrimitiveUtils.timerList(process)) {
                List<SpecialTypeStmt> timeoutList;
                List<SpecialTypeStmt> stopList;
                List<SpecialTypeStmt> startList = PrimitiveUtils.startOnTimer(tim, process);
                if (!startList.isEmpty() || !(stopList = PrimitiveUtils.stopOnTimer(tim, process)).isEmpty() || !(timeoutList = PrimitiveUtils.timeoutOnTimer(tim, process)).isEmpty()) continue;
                replacer.addRemove(tim);
            }
        }
        this.currentSystem.accept(replacer);
    }
}

