/*
 * Decompiled with CFR 0.152.
 */
package obp.languages.MoCCML;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import obp.languages.MoCCML.LTSTransition;

public class LTS {
    public String[] states;
    public int initialStateID;
    public String[] clocks;
    public LTSTransition[][] transitionGraph;
    public int[] initialData;
    public int nbTransitions;
    Map<String, Integer> state2id;

    public LTS(String[] clocks, String[] stateNames, int initialStateID, LTSTransition[] transitions, int[] initialData) {
        int i;
        HashMap adjacency = new HashMap(stateNames.length);
        this.clocks = clocks;
        this.states = stateNames;
        this.initialStateID = initialStateID;
        this.state2id = new IdentityHashMap<String, Integer>(this.states.length);
        for (i = 0; i < this.states.length; ++i) {
            this.state2id.put(this.states[i], i);
        }
        this.nbTransitions = transitions.length;
        for (i = 0; i < this.states.length; ++i) {
            adjacency.put(i, new ArrayList());
        }
        for (LTSTransition t : transitions) {
            ((List)adjacency.get(t.sourceID)).add(t);
        }
        this.transitionGraph = new LTSTransition[this.states.length][];
        for (int i2 = 0; i2 < this.states.length; ++i2) {
            List fanout = (List)adjacency.get(i2);
            this.transitionGraph[i2] = fanout.toArray(new LTSTransition[fanout.size()]);
        }
        this.initialData = initialData;
    }

    public int getStateID(String name) {
        Integer id = this.state2id.get(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public String[] getStates() {
        return this.states;
    }

    public String[] getClocks() {
        return this.clocks;
    }

    public int getStateCount() {
        return this.states.length;
    }

    public int getTransitionCount() {
        return this.nbTransitions;
    }

    public LTSTransition[] getFanout(int state) {
        return this.transitionGraph[state];
    }
}

