/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.behaviour.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.behaviour.statements.ActionStatement;
import obp.if2.data.Expression;

public abstract class CreateOrGetAction
extends ActionStatement {
    private Expression lhs;
    private final List<Expression> parametersList = new ArrayList<Expression>();

    public Expression getLhs() {
        return this.lhs;
    }

    public void setLhs(Expression newValue) {
        if (this.lhs == null ? newValue != null : !this.lhs.equals(newValue)) {
            this.lhs = newValue;
        }
    }

    public List<Expression> getParametersList() {
        return Collections.unmodifiableList(this.parametersList);
    }

    public int getParametersCount() {
        return this.parametersList.size();
    }

    public Expression getParameters(int index) {
        if (index < 0 || index >= this.getParametersCount()) {
            return null;
        }
        return this.parametersList.get(index);
    }

    public void addParameters(Expression newValue) {
        this.addParameters(this.getParametersCount(), newValue);
    }

    public void addParameters(int index, Expression newValue) {
        this.parametersList.add(index, newValue);
    }

    public Expression setParameters(int index, Expression newValue) {
        return this.parametersList.set(index, newValue);
    }

    public void addAllParameters(Collection<Expression> toAddList) {
        for (Expression newValue : toAddList) {
            this.addParameters(this.getParametersCount(), newValue);
        }
    }

    public void removeParameters(Expression value) {
        int index = this.parametersList.indexOf(value);
        if (index >= 0) {
            this.removeParameters(index);
        }
    }

    public void removeParameters(int index) {
        this.parametersList.remove(index);
    }

    @Override
    public abstract void accept(If2Visitor var1);
}

