/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.LTL.model.FormulaReference;
import obp.cdl.Activity;
import obp.cdl.CdlVisitor;
import obp.cdl.Declaration;
import obp.cdl.Option;
import obp.cdl.ParActivity;
import obp.cdl.PropertyReference;
import obp.cdl.RestrictionReference;
import obp.predicate.Predicate;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class CDLDeclaration
extends Declaration
implements BoostObject {
    private final List<FormulaReference> ltlList = new ArrayList<FormulaReference>();
    private final List<RestrictionReference> restrictionList = new ArrayList<RestrictionReference>();
    private final List<PropertyReference> propertyList = new ArrayList<PropertyReference>();
    private final List<Predicate> assertList = new ArrayList<Predicate>();
    private Predicate foldingPredicate;
    private Activity init;
    private ParActivity main;
    private final List<Option> optionList = new ArrayList<Option>();

    public CDLDeclaration() {
    }

    protected CDLDeclaration(Boost boost) {
        super(boost);
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, FormulaReference.class)) {
            this.ltlList.add((FormulaReference)oneChild);
        }
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, RestrictionReference.class)) {
            this.restrictionList.add((RestrictionReference)oneChild);
        }
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, PropertyReference.class)) {
            this.propertyList.add((PropertyReference)oneChild);
        }
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, Predicate.class)) {
            this.assertList.add((Predicate)oneChild);
        }
        this.foldingPredicate = (Predicate)boost.readObject(Predicate.class);
        this.init = (Activity)boost.readObject(Activity.class);
        this.main = (ParActivity)boost.readObject(ParActivity.class);
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, Option.class)) {
            this.optionList.add((Option)oneChild);
        }
    }

    public List<FormulaReference> getLtlList() {
        return Collections.unmodifiableList(this.ltlList);
    }

    public int getLtlCount() {
        return this.ltlList.size();
    }

    public FormulaReference getLtl(int index) {
        if (index < 0 || index >= this.getLtlCount()) {
            return null;
        }
        return this.ltlList.get(index);
    }

    public void addLtl(FormulaReference newValue) {
        this.addLtl(this.getLtlCount(), newValue);
    }

    public void addLtl(int index, FormulaReference newValue) {
        this.ltlList.add(index, newValue);
    }

    public FormulaReference setLtl(int index, FormulaReference newValue) {
        return this.ltlList.set(index, newValue);
    }

    public void addAllLtl(Collection<FormulaReference> toAddList) {
        for (FormulaReference newValue : toAddList) {
            this.addLtl(this.getLtlCount(), newValue);
        }
    }

    public void removeLtl(FormulaReference value) {
        int index = this.ltlList.indexOf(value);
        if (index >= 0) {
            this.removeLtl(index);
        }
    }

    public void removeLtl(int index) {
        this.ltlList.remove(index);
    }

    public List<RestrictionReference> getRestrictionList() {
        return Collections.unmodifiableList(this.restrictionList);
    }

    public int getRestrictionCount() {
        return this.restrictionList.size();
    }

    public RestrictionReference getRestriction(int index) {
        if (index < 0 || index >= this.getRestrictionCount()) {
            return null;
        }
        return this.restrictionList.get(index);
    }

    public void addRestriction(RestrictionReference newValue) {
        this.addRestriction(this.getRestrictionCount(), newValue);
    }

    public void addRestriction(int index, RestrictionReference newValue) {
        this.restrictionList.add(index, newValue);
    }

    public RestrictionReference setRestriction(int index, RestrictionReference newValue) {
        return this.restrictionList.set(index, newValue);
    }

    public void addAllRestriction(Collection<RestrictionReference> toAddList) {
        for (RestrictionReference newValue : toAddList) {
            this.addRestriction(this.getRestrictionCount(), newValue);
        }
    }

    public void removeRestriction(RestrictionReference value) {
        int index = this.restrictionList.indexOf(value);
        if (index >= 0) {
            this.removeRestriction(index);
        }
    }

    public void removeRestriction(int index) {
        this.restrictionList.remove(index);
    }

    public List<PropertyReference> getPropertyList() {
        return Collections.unmodifiableList(this.propertyList);
    }

    public int getPropertyCount() {
        return this.propertyList.size();
    }

    public PropertyReference getProperty(int index) {
        if (index < 0 || index >= this.getPropertyCount()) {
            return null;
        }
        return this.propertyList.get(index);
    }

    public void addProperty(PropertyReference newValue) {
        this.addProperty(this.getPropertyCount(), newValue);
    }

    public void addProperty(int index, PropertyReference newValue) {
        this.propertyList.add(index, newValue);
    }

    public PropertyReference setProperty(int index, PropertyReference newValue) {
        return this.propertyList.set(index, newValue);
    }

    public void addAllProperty(Collection<PropertyReference> toAddList) {
        for (PropertyReference newValue : toAddList) {
            this.addProperty(this.getPropertyCount(), newValue);
        }
    }

    public void removeProperty(PropertyReference value) {
        int index = this.propertyList.indexOf(value);
        if (index >= 0) {
            this.removeProperty(index);
        }
    }

    public void removeProperty(int index) {
        this.propertyList.remove(index);
    }

    public List<Predicate> getAssertList() {
        return Collections.unmodifiableList(this.assertList);
    }

    public int getAssertCount() {
        return this.assertList.size();
    }

    public Predicate getAssert(int index) {
        if (index < 0 || index >= this.getAssertCount()) {
            return null;
        }
        return this.assertList.get(index);
    }

    public void addAssert(Predicate newValue) {
        this.addAssert(this.getAssertCount(), newValue);
    }

    public void addAssert(int index, Predicate newValue) {
        this.assertList.add(index, newValue);
    }

    public Predicate setAssert(int index, Predicate newValue) {
        return this.assertList.set(index, newValue);
    }

    public void addAllAssert(Collection<Predicate> toAddList) {
        for (Predicate newValue : toAddList) {
            this.addAssert(this.getAssertCount(), newValue);
        }
    }

    public void removeAssert(Predicate value) {
        int index = this.assertList.indexOf(value);
        if (index >= 0) {
            this.removeAssert(index);
        }
    }

    public void removeAssert(int index) {
        this.assertList.remove(index);
    }

    public Predicate getFoldingPredicate() {
        return this.foldingPredicate;
    }

    public void setFoldingPredicate(Predicate newValue) {
        if (this.foldingPredicate == null ? newValue != null : !this.foldingPredicate.equals(newValue)) {
            this.foldingPredicate = newValue;
        }
    }

    public Activity getInit() {
        return this.init;
    }

    public void setInit(Activity newValue) {
        if (this.init == null ? newValue != null : !this.init.equals(newValue)) {
            this.init = newValue;
        }
    }

    public ParActivity getMain() {
        return this.main;
    }

    public void setMain(ParActivity newValue) {
        if (this.main == null ? newValue != null : !this.main.equals(newValue)) {
            this.main = newValue;
        }
    }

    public List<Option> getOptionList() {
        return Collections.unmodifiableList(this.optionList);
    }

    public int getOptionCount() {
        return this.optionList.size();
    }

    public Option getOption(int index) {
        if (index < 0 || index >= this.getOptionCount()) {
            return null;
        }
        return this.optionList.get(index);
    }

    public void addOption(Option newValue) {
        this.addOption(this.getOptionCount(), newValue);
    }

    public void addOption(int index, Option newValue) {
        this.optionList.add(index, newValue);
    }

    public Option setOption(int index, Option newValue) {
        return this.optionList.set(index, newValue);
    }

    public void addAllOption(Collection<Option> toAddList) {
        for (Option newValue : toAddList) {
            this.addOption(this.getOptionCount(), newValue);
        }
    }

    public void removeOption(Option value) {
        int index = this.optionList.indexOf(value);
        if (index >= 0) {
            this.removeOption(index);
        }
    }

    public void removeOption(int index) {
        this.optionList.remove(index);
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.ltlList);
        BoostUtil.writeObjectCollection((Boost)boost, this.restrictionList);
        BoostUtil.writeObjectCollection((Boost)boost, this.propertyList);
        BoostUtil.writeObjectCollection((Boost)boost, this.assertList);
        boost.writeObject((BoostObject)this.foldingPredicate);
        boost.writeObject((BoostObject)this.init);
        boost.writeObject((BoostObject)this.main);
        BoostUtil.writeObjectCollection((Boost)boost, this.optionList);
    }

    @Override
    public void accept(CdlVisitor visitor) {
        visitor.visitCDLDeclaration(this);
    }
}

